Option Strict Off
Option Explicit On
Friend Class Step1
	Inherits System.Windows.Forms.Form
	'Step 1 Normal operation:Read data.
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		'Close Aplication
		Me.Close()
		
	End Sub
	
	Private Sub Command1_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command1.Click
		
		'Data size clear
		Label1.Text = ""
		System.Windows.Forms.Application.DoEvents()
		
		With OPOSCheckScanner1
			
			'EventClear
			.ClearInput()
			
			'Ready to fired event
			.DataEventEnabled = True
			
			'Timeout function.
			While .BeginInsertion(3000) = OPOS_E_TIMEOUT
				If (MsgBox("Please insert a check.", MsgBoxStyle.OKCancel + MsgBoxStyle.Question) = MsgBoxResult.Cancel) Then
					.EndInsertion()
					Exit Sub
				End If
				System.Windows.Forms.Application.DoEvents()
			End While
			
			'Set paper & Scanning
			.EndInsertion()
			
			'Call to retrieve an image to the ImageData proparty
			.RetrieveImage(CHK_CROP_AREA_ENTIRE_IMAGE)
			
		End With
		
	End Sub
	
	Private Sub Step1_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		Dim OBJChkScan As Object
		
		With OPOSCheckScanner1
			
			'Open the device
			'Use a Logical Device Name which has been set on the SetupPOS.
			.Open("Unit1")
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("This device has not been registered, or cannot use.")
				GoTo LoadError
			End If
			
			'Get the exclusive control right for the opened device.
			'Then the device is disable from other application.
			'(Notice:When using an old CO, use the Claim.)
			.ClaimDevice(1000)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to get the exclusive right for the device.")
				GoTo LoadError
			End If
			
			'Power reporting
			If .CapPowerReporting <> OPOS_PR_NONE Then
				.PowerNotify = OPOS_PN_ENABLED
			End If
			
			'Enable the device.
			.DeviceEnabled = True
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Now the device is disable to use.")
				GoTo LoadError
			End If
			
			'Ready to fired event
			.DataEventEnabled = True
			
			'Read TIFF file format
			.ImageFormat = CHK_IF_TIFF
			
			'Read BMP file format
			'.ImageFormat = CHK_IF_BMP
			
			'Read JPEG file format
			'.ImageFormat = CHK_IF_JPEG
			
		End With
		
		Exit Sub
		
		'Go to
		'Disable button
LoadError: 
		
		For	Each OBJChkScan In Me.Controls
			If OBJChkScan.Name <> "OPOSCheckScanner1" Then
				OBJChkScan.Enabled = False
			End If
		Next OBJChkScan
		
		'Enabled exit botton
		cmdExit.Enabled = True 'Only the exit button is enabled.
		
	End Sub
	
	Private Sub Step1_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSCheckScanner1
			
			'Cancel the device
			.DeviceEnabled = False
			
			'Release the device exclusive control right.
			'(Notice:When using an old CO, use the Release.)
			.ReleaseDevice()
			
			'Finish using the device.
			.Close()
			
		End With
		
	End Sub
	
	Private Sub OPOSCheckScanner1_DataEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposCheckScanner_CCO._IOPOSCheckScannerEvents_DataEventEvent) Handles OPOSCheckScanner1.DataEvent
		
		'Dispay ImageDataSize
		Label1.Text = CStr(GetDataSize) & " byte"
		
	End Sub
	
	Private Sub OPOSCheckScanner1_ErrorEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposCheckScanner_CCO._IOPOSCheckScannerEvents_ErrorEventEvent) Handles OPOSCheckScanner1.ErrorEvent
		
		'Error MessageBox
		MsgBox("CheckScanner Error!" & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended))
		
		'Begin removal
		If eventArgs.ResultCode = OPOS_E_ILLEGAL Then
			With OPOSCheckScanner1
				.BeginRemoval(OPOS_FOREVER)
				.EndRemoval()
			End With
		End If
		
	End Sub
	
	Private Function GetDataSize() As Integer
		
		Dim strIMSizeData As String
		Dim lImageDataSize As Integer
		Dim lNowBinaryConversion As Integer
		
		With OPOSCheckScanner1
			
			'Now BinaryConversion
			lNowBinaryConversion = .BinaryConversion
			
			'SetBinaryConversion
			.BinaryConversion = OPOS_BC_NIBBLE
			
			'Copy to ImageData
			strIMSizeData = .ImageData
			
			'GetDataSize
			lImageDataSize = Len(strIMSizeData) / 2
			
			'Re BinaryConversion
			.BinaryConversion = lNowBinaryConversion
			
		End With
		
		'Return ImageDataSize
		GetDataSize = lImageDataSize
		
	End Function
End Class