﻿Option Strict Off
Option Explicit On
Imports VB = Microsoft.VisualBasic
Friend Class Step12

    Inherits System.Windows.Forms.Form

    Private m_bIsLandscape As Boolean = False

Private Sub cmdLandscape_Click(sender As System.Object, e As System.EventArgs) Handles cmdLandscape.Click

    m_bIsLandscape = True
    Dim pString As String = ""

    With OPOSLineDisplay1
        'Clear displayed image
        .DirectIO(DISP_DI_CLEAR_IMAGE, DISP_DI_DUMMY, pString)

        'Clear displayed barcode
        .DirectIO(DISP_DI_CLEAR_BARCODE, DISP_DI_DUMMY, pString)

        'Delete all window
        .CurrentWindow = 1
        .DestroyWindow()
        .CurrentWindow = 2
        .DestroyWindow()
    End With

    With OPOSLineDisplay1
        'Layout No:25(Upper: image, Lower: text)
        .DirectIO(DISP_DI_LAYOUT, 25, pString)

        'Create a 5x17 window(Background color: White)
        .CreateWindow(0, 0, 5, 17, 5, 17)
        .DirectIO(DISP_DI_DISPLAY_BACKGROUND_COLOR, DISP_DI_WHITE, pString)

        'Create a 5x16 window from row: 0 column: 18(Background color: Cyan)
        .CreateWindow(0, 17, 5, 16, 5, 16)
        .DirectIO(DISP_DI_DISPLAY_BACKGROUND_COLOR, DISP_DI_CYAN, pString)

        'Start slideshow
        .DirectIO(DISP_DI_SLIDESHOW, DISP_DI_SLIDESHOW_START, pString)
    End With

End Sub

Private Sub cmdPortrait_Click(sender As System.Object, e As System.EventArgs) Handles cmdPortrait.Click

    m_bIsLandscape = False
    Dim pString As String = ""

    With OPOSLineDisplay1
        'Clear displayed image
        .DirectIO(DISP_DI_CLEAR_IMAGE, DISP_DI_DUMMY, pString)

        'Clear displayed barcode
        .DirectIO(DISP_DI_CLEAR_BARCODE, DISP_DI_DUMMY, pString)

        'Delete all window
        .CurrentWindow = 1
        .DestroyWindow()
        .CurrentWindow = 2
        .DestroyWindow()
    End With

    With OPOSLineDisplay1
        'Layout No:27(Upper: image, Lower: text)
        .DirectIO(DISP_DI_LAYOUT, 27, pString)

        'Create a 3x20 window(Background color: Cyan)
        .CreateWindow(0, 0, 3, 20, 3, 20)
        .DirectIO(DISP_DI_DISPLAY_BACKGROUND_COLOR, DISP_DI_CYAN, pString)

        'Create a 5x20 window(Background color: White)
        .CreateWindow(3, 0, 5, 20, 5, 20)
        .DirectIO(DISP_DI_DISPLAY_BACKGROUND_COLOR, DISP_DI_WHITE, pString)

        'Start slideshow
        .DirectIO(DISP_DI_SLIDESHOW, DISP_DI_SLIDESHOW_START, pString)
    End With

End Sub

Private Sub cmdOrder_Click(sender As System.Object, e As System.EventArgs) Handles cmdOrder.Click

    Dim pString As String = ""

    'Clear displayed barcode
    With OPOSLineDisplay1
        .DirectIO(DISP_DI_CLEAR_BARCODE, DISP_DI_DUMMY, pString)
    End With

    'When the slide show is not running, the slide show starts after the image is erased
    With OPOSLineDisplay1
        'Clear displayed image
        .DirectIO(DISP_DI_CLEAR_IMAGE, DISP_DI_DUMMY, pString)

        'Start slideshow
        .DirectIO(DISP_DI_SLIDESHOW, DISP_DI_SLIDESHOW_START, pString)
    End With

    If m_bIsLandscape = True Then
        With OPOSLineDisplay1
            .CurrentWindow = 1
            .ClearText()
            'Set the specified character color
            .DirectIO(DISP_DI_SET_TEXT_COLOR, DISP_DI_BLACK, pString)

            .DisplayText("Item:" + vbCrLf, DISP_DT_NORMAL)
            .DisplayText("     Cut & Sewn" + vbCrLf, DISP_DT_NORMAL)
            .DisplayText(vbCrLf, DISP_DT_NORMAL)
            .DisplayText("U.PC.45.00->", DISP_DT_NORMAL)

            'Set the specified character color
            .DirectIO(DISP_DI_SET_TEXT_COLOR, DISP_DI_RED, pString)
            .DisplayText("22.50" + vbCrLf, DISP_DT_NORMAL)

            'Set the specified character color
            .DirectIO(DISP_DI_SET_TEXT_COLOR, DISP_DI_BLACK, pString)
            .DisplayText("QTY:            3", DISP_DT_NORMAL)

            .CurrentWindow = 2
            .ClearText()

            'Set the specified character color
            .DirectIO(DISP_DI_SET_TEXT_COLOR, DISP_DI_BLACK, pString)
            .DisplayText("SubTotal:" + vbCrLf, DISP_DT_NORMAL)
            .DisplayText("         $67.50" + vbCrLf, DISP_DT_NORMAL)
        End With
    Else
        With OPOSLineDisplay1
            .CurrentWindow = 1
            .ClearText()

            'Set the specified character color
            .DirectIO(DISP_DI_SET_TEXT_COLOR, DISP_DI_BLACK, pString)
            .DisplayText("Item:" + vbCrLf, DISP_DT_NORMAL)
            .DisplayText("     Cut & Sewn" + vbCrLf, DISP_DT_NORMAL)

            .CurrentWindow = 2
            .ClearText()

            'Set the specified character color
            .DirectIO(DISP_DI_SET_TEXT_COLOR, DISP_DI_BLACK, pString)
            .DisplayText("Qty:               3" + vbCrLf, DISP_DT_NORMAL)
            .DisplayText("U.PC.:        $45.00" + vbCrLf, DISP_DT_NORMAL)

            'Set the specified character color
            .DirectIO(DISP_DI_SET_TEXT_COLOR, DISP_DI_RED, pString)
            .DisplayText("             (22.50)" + vbCrLf, DISP_DT_NORMAL)

            'Set the specified character color
            .DirectIO(DISP_DI_SET_TEXT_COLOR, DISP_DI_BLACK, pString)
            .DisplayText(vbCrLf, DISP_DT_NORMAL)
            .DisplayText("SubTotal:     $67.50", DISP_DT_NORMAL)
        End With
    End If

End Sub

Private Sub cmdCheck_Click(sender As System.Object, e As System.EventArgs) Handles cmdCheck.Click

    Dim pString As String = ""

    With OPOSLineDisplay1
        'Stop slideshow
        .DirectIO(DISP_DI_SLIDESHOW, DISP_DI_SLIDESHOW_STOP, pString)
    End With

    If m_bIsLandscape = True Then

        With OPOSLineDisplay1
            'Display registered image
            .DirectIO(DISP_DI_DISPLAY_IMAGE, 1, "0,0,800,240")

            .CurrentWindow = 1
            .ClearText()

            'Set the specified character color
            .DirectIO(DISP_DI_SET_TEXT_COLOR, DISP_DI_BLACK, pString)
            .DisplayText("Store Information" + vbCrLf, DISP_DT_NORMAL)

            .CurrentWindow = 2
            .ClearText()

            'Set the specified character color
            .DirectIO(DISP_DI_SET_TEXT_COLOR, DISP_DI_BLACK, pString)
            .DisplayText("Total:   $66.50" + vbCrLf, DISP_DT_NORMAL)
            .DisplayText("Cash:   $100.50" + vbCrLf, DISP_DT_NORMAL)
            .DisplayText("Change:  $34.00", DISP_DT_NORMAL)

            'Register barcode data
            .DirectIO(DISP_DI_SET_BARCODE_DATA, DISP_DI_QRCODE_MODEL_2, "https://www.epson-pos.com/")

            'Display registered barcode data
            .DirectIO(DISP_DI_DISPLAY_BARCODE, DISP_DI_QRCODE_MODEL_2, "120,70,4")
        End With
    Else

        With OPOSLineDisplay1
            'Display registered image
            .DirectIO(DISP_DI_DISPLAY_IMAGE, 2, "0,0,480,400")

            .CurrentWindow = 1
            .ClearText()

            'Set the specified character color
            .DirectIO(DISP_DI_SET_TEXT_COLOR, DISP_DI_BLACK, pString)
            .DisplayText("Total:        $67.50" + vbCrLf, DISP_DT_NORMAL)
            .DisplayText("Cash:        $100.00" + vbCrLf, DISP_DT_NORMAL)
            .DisplayText("Change:       $32.50", DISP_DT_NORMAL)

            .CurrentWindow = 2
            .ClearText()

            'Set the specified character color
            .DirectIO(DISP_DI_SET_TEXT_COLOR, DISP_DI_BLACK, pString)
            .DisplayTextAt(1, 1, "Store Information" + vbCrLf, DISP_DT_NORMAL)

            'Register barcode data
            .DirectIO(DISP_DI_SET_BARCODE_DATA, DISP_DI_QRCODE_MODEL_2, "https://www.epson-pos.com/")

            'Display registered barcode data
            .DirectIO(DISP_DI_DISPLAY_BARCODE, DISP_DI_QRCODE_MODEL_2, "160,260,4")
        End With
    End If

End Sub

Private Sub cmdStart_Click(sender As System.Object, e As System.EventArgs) Handles cmdStart.Click

    'The Slideshow function works by pre-registering the images using utility
    Dim pString As String = ""

    With OPOSLineDisplay1
        'Clear displayed image
        .DirectIO(DISP_DI_CLEAR_IMAGE, DISP_DI_DUMMY, pString)
        'Start slideshow
        .DirectIO(DISP_DI_SLIDESHOW, DISP_DI_SLIDESHOW_START, pString)
    End With

End Sub

Private Sub cmdStop_Click(sender As System.Object, e As System.EventArgs) Handles cmdStop.Click

    Dim pString As String = ""

    With OPOSLineDisplay1
        'Stop slideshow
        .DirectIO(DISP_DI_SLIDESHOW, DISP_DI_SLIDESHOW_STOP, pString)
    End With

End Sub

Private Sub cmdExit_Click(sender As System.Object, e As System.EventArgs) Handles cmdExit.Click

    Me.Close()

End Sub

Private Sub Step12_FormClosed(sender As Object, e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed

    With OPOSLineDisplay1
        .DeviceEnabled = False
        .ReleaseDevice()
        .Close()
    End With

End Sub


Private Sub Step12_Load(sender As Object, e As System.EventArgs) Handles Me.Load
    With OPOSLineDisplay1
        .Open("Unit1")
        If .ResultCode <> OPOS_SUCCESS Then
            MsgBox("Fails to open the device.", MsgBoxStyle.Exclamation)
            GoTo LoadError
        End If

        .ClaimDevice(1000)
        If .ResultCode <> OPOS_SUCCESS Then
            MsgBox("Fails to claim the device.", MsgBoxStyle.Exclamation)
            GoTo LoadError
        End If

        If .CapPowerReporting <> OPOS_PR_NONE Then
            .PowerNotify = OPOS_PN_ENABLED
        End If

        .DeviceEnabled = True
        If .ResultCode <> OPOS_SUCCESS Then
            MsgBox("Disable to use the device.", MsgBoxStyle.Exclamation)
            GoTo LoadError
        End If

    End With

    'Initialize layout
    m_bIsLandscape = True
    Dim pString As String = ""

    With OPOSLineDisplay1
        'Layout No:25(Upper: image, Lower: text)
        .DirectIO(DISP_DI_LAYOUT, 25, pString)

        'Create a 5x17 window(Background color: White)
        .CreateWindow(0, 0, 5, 17, 5, 17)
        .DirectIO(DISP_DI_DISPLAY_BACKGROUND_COLOR, DISP_DI_WHITE, pString)

        'Create a 5x16 window from row: 0 column: 18(Background color: Cyan)
        .CreateWindow(0, 17, 5, 16, 5, 16)
        .DirectIO(DISP_DI_DISPLAY_BACKGROUND_COLOR, DISP_DI_CYAN, pString)

        'Start slideshow
        .DirectIO(DISP_DI_SLIDESHOW, DISP_DI_SLIDESHOW_START, pString)

        'Register image files on Display
        .DirectIO(DISP_DI_REGISTER_IMAGE, 1, "..\ThankE800.png")
        .DirectIO(DISP_DI_REGISTER_IMAGE, 2, "..\ThankE.png")
    End With

    Exit Sub

LoadError:

    ' All disable to button.
    cmdLandscape.Enabled = False
    cmdPortrait.Enabled = False
    cmdOrder.Enabled = False
    cmdCheck.Enabled = False
    cmdStart.Enabled = False
    cmdStop.Enabled = False

    ' Enable to [Close] button only.
    cmdExit.Enabled = True

End Sub

Private Sub OPOSLineDisplay1_StatusUpdateEvent(ByVal sender As System.Object, ByVal eventArgs As AxOposLineDisplay_CCO._IOPOSLineDisplayEvents_StatusUpdateEventEvent) Handles OPOSLineDisplay1.StatusUpdateEvent

    'The Power Reporting Requirements fires the event when the device power status is changed.
    Select Case eventArgs.data
        Case OPOS_SUE_POWER_ONLINE ' The device is powered on.
            MsgBox("The device is powered on.")
        Case OPOS_SUE_POWER_OFF ' The device is powered off, or unconnected.
            MsgBox("The device is powered off, or unconnected.")
        Case OPOS_SUE_POWER_OFFLINE ' The device is powered on, but disable to operate.
            MsgBox("The device is powered on, but disable to operate..")
        Case OPOS_SUE_POWER_OFF_OFFLINE ' The device is powered off or off-line.
            MsgBox("The device is powered off or off-line.")
    End Select

End Sub
End Class