Option Strict Off
Option Explicit On
Friend Class Step2
	Inherits System.Windows.Forms.Form
	'Step 2 Check the status of the cash drawer.
	
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	'Open a drawer
	'
	Private Sub Command1_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command1.Click
		
		'Open a drawer
		OPOSCashDrawer1.OpenDrawer()
		
	End Sub
	
	Private Sub Step2_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSCashDrawer1
			.Open("Unit1")
			.ClaimDevice(1000)
			
			' If support the CapPowerReporting, enable the Power Reporting Requirements.
			If .CapPowerReporting <> OPOS_PR_NONE Then
				.PowerNotify = OPOS_PN_ENABLED
			End If
			
			.DeviceEnabled = True
		End With
		
	End Sub
	
	Private Sub Step2_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSCashDrawer1
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
	End Sub
	
	Private Sub OPOSCashDrawer1_StatusUpdateEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposCashDrawer_CCO._IOPOSCashDrawerEvents_StatusUpdateEventEvent) Handles OPOSCashDrawer1.StatusUpdateEvent
		
		Select Case eventArgs.Data
			Case CASH_SUE_DRAWERCLOSED 'Drawer is closed
				Text1.Text = "Close"
			Case CASH_SUE_DRAWEROPEN 'Drawer is opened
				Text1.Text = "Open"
				'The Power Reporting Requirements fires the event when the device power status is changed.
			Case OPOS_SUE_POWER_ONLINE ' The device is powered on.
				Text2.Text = "ready"
			Case OPOS_SUE_POWER_OFF ' The device is powered off, or unconnected.
				Text2.Text = "OFF"
			Case OPOS_SUE_POWER_OFFLINE ' The device is powered on, but disable to operate.
				Text2.Text = "not ready"
			Case OPOS_SUE_POWER_OFF_OFFLINE ' The device is powered off or off-line.
				Text2.Text = "Offline"
		End Select
	End Sub
End Class