Option Strict Off
Option Explicit On
Friend Class Step3
	Inherits System.Windows.Forms.Form
	'Step 3   Display detailed information of the read data.
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	Private Sub Command1_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command1.Click
		
		While OPOSMICR1.BeginInsertion(3000) = OPOS_E_TIMEOUT
			If (MsgBox("Please insert a check.", MsgBoxStyle.OKCancel + MsgBoxStyle.Question) = MsgBoxResult.Cancel) Then
				OPOSMICR1.EndInsertion()
				Exit Sub
			End If
		End While
		OPOSMICR1.EndInsertion()
		
	End Sub
	
	Private Sub Command2_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command2.Click
		
		If OPOSMICR1.BeginRemoval(3000) = OPOS_E_TIMEOUT Then
			MsgBox("Please remove a check.")
		End If
		
		While OPOSMICR1.EndRemoval <> OPOS_SUCCESS
			MsgBox("Please remove a check.")
		End While
		
	End Sub
	
	Private Sub Step3_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSMICR1
			.Open("Unit1")
			.ClaimDevice(1000)
			.DeviceEnabled = True
			.DataEventEnabled = True
		End With
		
	End Sub
	
	Private Sub Step3_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSMICR1
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
	End Sub
	
	Private Sub OPOSMICR1_DataEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposMICR_CCO._IOPOSMICREvents_DataEventEvent) Handles OPOSMICR1.DataEvent
		
		Dim sBuf As String
		
		With OPOSMICR1
			Text1.Text = .RawData
			Text2.Text = .AccountNumber
			Text3.Text = .Amount
			Text4.Text = .BankNumber
			
			Select Case .CheckType
				Case MICR_CT_PERSONAL : sBuf = "PERSONAL"
				Case MICR_CT_BUSINESS : sBuf = "BUSINESS"
				Case MICR_CT_UNKNOWN : sBuf = "UNKNOWN"
			End Select
			Text5.Text = sBuf
			
			Select Case .CountryCode
				Case MICR_CC_USA : sBuf = "USA"
				Case MICR_CC_CANADA : sBuf = "CANADA"
				Case MICR_CC_MEXICO : sBuf = "MEXICO"
				Case MICR_CC_UNKNOWN : sBuf = "UNKNOWN"
			End Select
			Text6.Text = sBuf
			
			Text7.Text = .EPC
			Text8.Text = .SerialNumber
			Text9.Text = .TransitNumber
			
			.DataEventEnabled = True
		End With
		
	End Sub
End Class