Option Strict Off
Option Explicit On
Friend Class Step6
	Inherits System.Windows.Forms.Form
	'Step 6  Device Statistics.
	
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	Private Sub cmdRetrieveSt_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdRetrieveSt.Click
		
		Dim strParam As String
		Dim lLen As Integer
		Dim strErrMsg As String
		Dim strXMLPath As String
		Dim strFindXMLPath As String
		
		strParam = txtRetrieveSt.Text
		strErrMsg = ""
		strFindXMLPath = ""
		
		'Obtains the statistics of the device and stores it in a file.
		With OPOSMICR1
			.RetrieveStatistics(strParam)
			If (.ResultCode <> OPOS_SUCCESS) Then
				strErrMsg = "RetrieveStatistics method error." & vbCrLf & vbCrLf
				strErrMsg = strErrMsg & "ResultCode = " & CStr(.ResultCode) & vbCrLf
				strErrMsg = strErrMsg & "ResultCodeExtended = " & CStr(.ResultCodeExtended)
				MsgBox(strErrMsg, MsgBoxStyle.OKOnly + MsgBoxStyle.Exclamation, "MICR")
				Exit Sub
			End If
		End With
		
		strXMLPath = My.Application.Info.DirectoryPath & "\Sample.xml"
		'Delete XML file.
		strFindXMLPath = Dir(strXMLPath)
		If strFindXMLPath <> "" Then
			Kill((strXMLPath))
		End If
		'Create XML file.
		FileOpen(1, strXMLPath, OpenMode.Binary, OpenAccess.Write)
		FilePut(1, strParam)
		FileClose(1)
		
		' Opens another window and indicates the information of the XML file.
		Step6Browser.Show()
		
	End Sub
	
	Private Sub Command1_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command1.Click
		
		Dim ret As Integer
		
		Do 
			ret = OPOSMICR1.BeginInsertion(3000)
			If ret = OPOS_SUCCESS Then
				Exit Do
			ElseIf ret = OPOS_E_TIMEOUT Then 
				If (MsgBox("Please insert a check.", MsgBoxStyle.OKCancel + MsgBoxStyle.Question) = MsgBoxResult.Cancel) Then
					OPOSMICR1.EndInsertion()
					Exit Sub
				End If
			Else
				MsgBox("insert error.")
				Exit Do
			End If
		Loop 
		
		OPOSMICR1.EndInsertion()
		
	End Sub
	
	Private Sub Command2_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command2.Click
		
		Dim ret As Integer
		Dim i As Short
		
		ret = OPOSMICR1.BeginRemoval(3000)
		If ret = OPOS_E_TIMEOUT Then
			MsgBox("Please remove a check.")
		ElseIf ret <> OPOS_SUCCESS Then 
			MsgBox("remove error.")
			Exit Sub
		End If
		
		i = 1
		Do While OPOSMICR1.EndRemoval <> OPOS_SUCCESS
			MsgBox("Please remove a check.")
			' error message is 5 Limit
			i = i + 1
			If i = 5 Then Exit Do
		Loop 
		
	End Sub
	
	Private Sub Command3_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Command3.Click
		
		Dim fDate As String
		
		' Begining Process
		fDate = VB6.Format(Now, "hh:mm AM/PM   d mmm, yyyy")
		' Endorse printout
		With OPOSPOSPrinter1
			' Select the reverse side
			.ChangePrintSide(PTR_PS_SIDE2)
			
			.PrintNormal(PTR_S_SLIP, vbLf)
			.PrintNormal(PTR_S_SLIP, Chr(&H1B) & "|rADATE" & fDate & vbLf)
			.PrintNormal(PTR_S_SLIP, Chr(&H1B) & "|rA" & "SEIKO EPSON CORPORATION" & vbLf)
		End With
		
	End Sub
	
	Private Sub Step6_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		
		With OPOSMICR1
			.Open("Unit1")
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("This device has not been registered, or cannot use.")
				GoTo LoadError
			End If
			
			.ClaimDevice(1000)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to get the exclusive right for the device.")
				GoTo LoadError
			End If
			
			If .CapPowerReporting <> OPOS_PR_NONE Then
				.PowerNotify = OPOS_PN_ENABLED
			End If
			
			.DeviceEnabled = True
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Now the device is disable to use.")
				GoTo LoadError
			End If
			
			.DataEventEnabled = True
			
			' Set the edit box of parameter input.
			txtRetrieveSt.Text = "ModelName,HoursPoweredCount,GoodReadCount"
			
			' Checks whether it has function to obtain
			' the statistics of devices.
			' If it does not have the function, invalidates
			' the [Retrieve Statistics] button and the edit box
			' of parameter input.
			If .CapStatisticsReporting = False Then
				cmdRetrieveSt.Enabled = False
				txtRetrieveSt.Enabled = False
				Frame5.Enabled = False
			End If
			
		End With
		
		With OPOSPOSPrinter1
			.Open("Unit1")
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("This device has not been registered, or cannot use.")
				GoTo LoadError
			End If
			
			.ClaimDevice(1000)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to get the exclusive right for the device.")
				GoTo LoadError
			End If
			
			.DeviceEnabled = True
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Now the device is disable to use.")
				GoTo LoadError
			End If
			
			'<APG1.5>
			'Confirm whether supporting printing both sides, or not.
			If .CapSlpBothSidesPrint = False Then
				MsgBox("The device does not support for printing both sides. Fails to operate the step.")
				Command3.Enabled = False
			End If
		End With
		
		Exit Sub
		
LoadError: 
		Dim OBJ As Object
		For	Each OBJ In Me.Controls
			If (OBJ.Name <> "OPOSMICR1") And (OBJ.Name <> "OPOSPOSPrinter1") Then
				OBJ.Enabled = False
			End If
		Next OBJ
		cmdExit.Enabled = True 'Only the exit button is enabled.
		
	End Sub
	
	Private Sub Step6_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSPOSPrinter1
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
		With OPOSMICR1
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
	End Sub
	
	Private Sub OPOSMICR1_DataEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposMICR_CCO._IOPOSMICREvents_DataEventEvent) Handles OPOSMICR1.DataEvent
		
		Dim sBuf As String
		
		With OPOSMICR1
			Text1.Text = .RawData
			Text2.Text = .AccountNumber
			Text3.Text = .Amount
			Text4.Text = .BankNumber
			
			Select Case .CheckType
				Case MICR_CT_PERSONAL : sBuf = "PERSONAL"
				Case MICR_CT_BUSINESS : sBuf = "BUSINESS"
				Case MICR_CT_UNKNOWN : sBuf = "UNKNOWN"
			End Select
			Text5.Text = sBuf
			
			Select Case .CountryCode
				Case MICR_CC_USA : sBuf = "USA"
				Case MICR_CC_CANADA : sBuf = "CANADA"
				Case MICR_CC_MEXICO : sBuf = "MEXICO"
				Case MICR_CC_UNKNOWN : sBuf = "UNKNOWN"
			End Select
			Text6.Text = sBuf
			
			Text7.Text = .EPC
			Text8.Text = .SerialNumber
			Text9.Text = .TransitNumber
			
			.DataEventEnabled = True
		End With
		
	End Sub
	
	Private Sub OPOSMICR1_ErrorEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposMICR_CCO._IOPOSMICREvents_ErrorEventEvent) Handles OPOSMICR1.ErrorEvent
		
		MsgBox("MICR Error!" & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended))
		
	End Sub
	
	Private Sub OPOSMICR1_StatusUpdateEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposMICR_CCO._IOPOSMICREvents_StatusUpdateEventEvent) Handles OPOSMICR1.StatusUpdateEvent
		
		'The Power Reporting Requirements fires the event when the device power status is changed.
		Select Case eventArgs.Data
			Case OPOS_SUE_POWER_ONLINE ' The device is powered on.
				MsgBox("The device is powered on.")
			Case OPOS_SUE_POWER_OFF ' The device is powered off, or unconnected.
				MsgBox("The device is powered off, or unconnected.")
			Case OPOS_SUE_POWER_OFFLINE ' The device is powered on, but disable to operate.
				MsgBox("The device is powered on, but disable to operate..")
			Case OPOS_SUE_POWER_OFF_OFFLINE ' The device is powered off or off-line.
				MsgBox("The device is powered on or off-line.")
		End Select
		
	End Sub
End Class