Option Strict Off
Option Explicit On
Module OPOSEPSN
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // EPSON.H
	' //
	' //   General header file for EPSON Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 96-01-05 OPOS Release 1.0                                     Kata
	' // 96-04-25 OPOS Release 1.1; OPOS-J 1.0
	' // 96-07-08 DirectIO command for device specific details setting
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' // * default numeric property on error *
	
	Public Const PROP_ERRNUMBER As Integer = 0
	
	' // * default string property on error *
	
	
	' /////////////////////////////////////////////////////////////////////
	' // OPOS "ResultCodeExtended" Property Base Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const EPSNERREXT As Integer = 10000 ' // EPSON specific error base
	Public Const CASHERREXT As Integer = 20000 ' // Cash Drawer specific error base
	Public Const COINERREXT As Integer = 30000 ' // Coin Dispenser specific error base
	Public Const TOTERREXT As Integer = 40000 ' // Hard Totals specific error base
	Public Const LOCKERREXT As Integer = 50000 ' // Keylock specific error base
	Public Const DISPERREXT As Integer = 60000 ' // Line Display specific error base
	Public Const MICRERREXT As Integer = 70000 ' // MICR specific error base
	Public Const MSRERREXT As Integer = 80000 ' // MSR specific error base
	Public Const KBDERREXT As Integer = 90000 ' // POS Keyboard specific error base
	Public Const PTRERREXT As Integer = 100000 ' // POS Printer specific error base
	Public Const SCALERREXT As Integer = 110000 ' // Scale specific error base
	Public Const SCANERREXT As Integer = 120000 ' // Scanner specific error base
	Public Const SIGERREXT As Integer = 130000 ' // Signature Capture specific error base
	Public Const CHKERREXT As Integer = 140000 ' // Check Scanner specific error base
	Public Const EJERREXT As Integer = 150000 ' // Check Scanner specific error base
	Public Const PORTERREXT As Integer = 200000 ' // CPortDrv error base
	Public Const PARAMERREXT As Integer = 300000 ' // Parameter error base
	
	' /////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property Constants (EPSON specific)
	' /////////////////////////////////////////////////////////////////////
	
	Public Const OPOS_EX_BADCO As Integer = 1 + EPSNERREXT ' // invalid CO I/F
	Public Const OPOS_EX_BADPORT As Integer = 2 + EPSNERREXT ' // invalid Port
	Public Const OPOS_EX_BADDEVICE As Integer = 3 + EPSNERREXT ' // invalid DeviceName
	Public Const OPOS_EX_BADPROPIDX As Integer = 4 + EPSNERREXT ' // invalid property index
	Public Const OPOS_EX_BADPROPVAL As Integer = 5 + EPSNERREXT ' // invalid property value
	Public Const OPOS_EX_NOTSUPPORTED As Integer = 6 + EPSNERREXT ' // function not supported
	Public Const OPOS_EX_NOASB As Integer = 7 + EPSNERREXT ' // no ASB data returned(Ver1.0 - Ver1.9)
	Public Const OPOS_EX_NOINPUT As Integer = 7 + EPSNERREXT ' // no input data returned (Ver2.0 -)
	Public Const OPOS_EX_BUSY As Integer = 8 + EPSNERREXT ' // Async Output busy
	Public Const OPOS_EX_INCAPABLE As Integer = 9 + EPSNERREXT ' // incapable of the function
	Public Const OPOS_EX_INVALIDMODE As Integer = 10 + EPSNERREXT ' // invalid device mode
	Public Const OPOS_EX_REOPEN As Integer = 11 + EPSNERREXT ' // re-open
	Public Const OPOS_EX_BADPEEKRANGE As Integer = 12 + EPSNERREXT ' // PeekRange invalid
	Public Const OPOS_EX_BADDISPRANGE As Integer = 13 + EPSNERREXT ' // DispatchRange invalid
	Public Const OPOS_EX_NOTCLAIMED As Integer = 14 + EPSNERREXT ' // Not claimed (Release method used)
	Public Const OPOS_EX_TIMEOUT As Integer = 15 + EPSNERREXT ' // sync output timeout
	Public Const OPOS_EX_PORTUSED As Integer = 16 + EPSNERREXT ' // Port used by another
	Public Const OPOS_EX_PORTBUSY As Integer = 17 + EPSNERREXT ' // HOST Port busy
	Public Const OPOS_EX_MICRMODE As Integer = 18 + EPSNERREXT ' // MICR mode
	Public Const OPOS_EX_PORTLOCKED As Integer = 18 + EPSNERREXT ' // Port locked by another
	Public Const OPOS_EX_DEVBUSY As Integer = 19 + EPSNERREXT ' // device busy
	Public Const OPOS_EX_BADINF As Integer = 20 + EPSNERREXT ' // invalid INF file
	Public Const OPOS_EX_DISPOSE_ERROREVENT As Integer = 21 + EPSNERREXT ' // Disporse Error Event
	Public Const OPOS_EX_EXCEED_FILE_LIMIT As Integer = 22 + EPSNERREXT ' // Exceed FilesSystem limit
	Public Const OPOS_EX_UNAUTHORIZED As Integer = 23 + EPSNERREXT ' // Unauthorized action
	Public Const OPOS_EX_WAITING_REMOVAL As Integer = 24 + EPSNERREXT ' // Waiting for slip/check removal
	
	Public Const OPOS_EX_SOVERSION As Integer = 100 + EPSNERREXT ' // invalid SO version
	
	Public Const OPOS_EX_BADPARAM As Integer = PARAMERREXT ' // invalid parameter (general)
	
	Public Const OPOS_EFIRMWARE_WRITE_FAILED As Integer = 30 + EPSNERREXT ' // Failed to download firmware to device
	
	Public Const OPOS_EX_FAIL_MULTI_INTERFACE_PRINTING As Integer = 31 + EPSNERREXT ' // Failed the acquisition of the multi interface printing right.
	
	' /////////////////////////////////////////////////////////////////////
	' // DirectIO commands
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // EPSNCASH.H
	' //
	' //    header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 04-08-09 OPOS Release 1.8                                     
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // DirectIO Command
	Public Const DRW_DI_OPEN_DRAWER As Integer = 1
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // EpsnCScn.H
	' //
	' //    header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 01-09-14 OPOS Release ??                                     
	' // 02-12-16 OPOS Release 1.7                                     
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // DirectIO Command
	Public Const CHK_DI_ENDINSERTION_EXTEND As Integer = 2
	Public Const CHK_DI_PRESCAN As Integer = 3
	Public Const CHK_DI_READ_AREA As Integer = 4
	Public Const CHK_DI_IMAGE_FILTER As Integer = 5
	Public Const CHK_DI_ATTACHED_DATA As Integer = 6
	Public Const CHK_DI_SIZE_OFFSET As Integer = 7
	Public Const CHK_DI_BORDER_COLOR As Integer = 8
	Public Const CHK_DI_ROTATE_IMAGE As Integer = 9
	Public Const CHK_DI_TMSTORE_SET_INDEX As Integer = 10
	Public Const CHK_DI_TMSTORE_ERRORMODE As Integer = 11
	Public Const CHK_DI_TMSTORE_GET_FREEMEM As Integer = 12
	Public Const CHK_DI_CHANGE_MODE As Integer = 13
	Public Const CHK_DI_SHARPNESS_IMAGE As Integer = 14
	Public Const CHK_DI_GET_SUPPORT_FUNCTION As Integer = 15
	Public Const CHK_DI_RETRIEVEQUALITY As Integer = 17
	Public Const CHK_DI_RECOVER_ERROR As Integer = 18
	
	' // param2 CHK_DI_ENDINSERTION_EXTEND
	Public Const CHK_DI_EXTEND_DEFAULT As Integer = &H80000000
	Public Const CHK_DI_EXTEND_PRESCAN As Integer = &H1
	Public Const CHK_DI_EXTEND_READAREA As Integer = &H2
	Public Const CHK_DI_EXTEND_FILTER As Integer = &H4
	Public Const CHK_DI_EXTEND_ATTACHED As Integer = &H8
	Public Const CHK_DI_EXTEND_TMSTORE As Integer = &H10
	
	' // param2 CHK_DI_ROTATE_IMAGE
	Public Const CHK_DI_ROTATE_OFF As Integer = 0
	Public Const CHK_DI_ROTATE_ON As Integer = 1
	
	' // param2 CHK_DI_TMSTORE_ERRORMODE
	Public Const CHK_DI_ERRORMODE_CANCEL As Integer = 0
	Public Const CHK_DI_ERRORMODE_RETRY As Integer = 1
	
	' // param2 CHK_DI_CHANGE_MODE
	Public Const CHK_DI_MODE_CHECKSCANNER As Integer = &H0
	Public Const CHK_DI_MODE_CARDSCANNER As Integer = &H1
	
	' // param2 CHK_DI_SHARPNESS_IMAGE
	Public Const CHK_DI_SHARPNESS_OFF As Integer = &H0
	Public Const CHK_DI_SHARPNESS_ON As Integer = &H1
	
	' // param2 CHK_DI_GET_SUPPORT_FUNCTION
	Public Const CHK_DI_CHECKSCANNER As Integer = &H1
	Public Const CHK_DI_CARDSCANNER As Integer = &H2
	Public Const CHK_DI_TMSTORAGE As Integer = &H4
	Public Const CHK_DI_SHARPNESS As Integer = &H8
	
	' // param2 CHK_DI_RETRIEVEQUALITY
	Public Const CHK_DI_200X200 As Integer = &H1
	Public Const CHK_DI_100X100 As Integer = &H2
	
	' /////////////////////////////////////////////////////////////////////
	' // ResultCodeExtennded
	Public Const OPOS_ECHK_DATAERROR As Integer = CHKERREXT + 3
	Public Const OPOS_ECHK_CANCEL As Integer = CHKERREXT + 4
	Public Const OPOS_ECHK_DATAEND As Integer = CHKERREXT + 5
	Public Const OPOS_ECHK_TIMEOUT As Integer = CHKERREXT + 6
	Public Const OPOS_ECHK_NODATA As Integer = CHKERREXT + 7
	Public Const OPOS_ECHK_RESPONSE As Integer = CHKERREXT + 8
	Public Const OPOS_ECHK_PTRERROR As Integer = CHKERREXT + 9
	Public Const OPOS_ECHK_BADSIZE As Integer = CHKERREXT + 10
	Public Const OPOS_ECHK_ENCODE As Integer = CHKERREXT + 11
	Public Const OPOS_ECHK_EXIST As Integer = CHKERREXT + 13
	Public Const OPOS_ECHK_SAMEID As Integer = CHKERREXT + 14
	Public Const OPOS_ECHK_SAMETAG As Integer = CHKERREXT + 15
	Public Const OPOS_ECHK_TMSTORE_NOROOM As Integer = CHKERREXT + 16
	Public Const OPOS_ECHK_TMSTORE_WRITE As Integer = CHKERREXT + 17
	
	' /////////////////////////////////////////////////////////////////////
	' // EPSON original CheckScanner
	
	' /////////////////////////////////////////////////////////////////////
	' // "CapFormat" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const ECHK_CIF_TIFF As Integer = &H2
	Public Const ECHK_CIF_BMP As Integer = &H4
	Public Const ECHK_CIF_JPEG As Integer = &H8
	
	' /////////////////////////////////////////////////////////////////////
	' // "Color" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const ECHK_CCL_MONO As Integer = &H1
	Public Const ECHK_CCL_GRAYSCALE As Integer = &H2
	Public Const ECHK_CCL_16 As Integer = &H4
	Public Const ECHK_CCL_256 As Integer = &H8
	Public Const ECHK_CCL_FULL As Integer = &H10
	
	' /////////////////////////////////////////////////////////////////////
	' // "Format" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const ECHK_IF_TIFF As Integer = 2
	Public Const ECHK_IF_BMP As Integer = 3
	Public Const ECHK_IF_JPEG As Integer = 4
	
	' /////////////////////////////////////////////////////////////////////
	' // "ImageMemoryStatus" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const ECHK_IMS_EMPTY As Integer = 1
	Public Const ECHK_IMS_OK As Integer = 2
	Public Const ECHK_IMS_FULL As Integer = 3
	
	' /////////////////////////////////////////////////////////////////////
	' // "MapMode" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const ECHK_MM_DOTS As Integer = 1
	Public Const ECHK_MM_TWIPS As Integer = 2
	Public Const ECHK_MM_ENGLISH As Integer = 3
	Public Const ECHK_MM_METRIC As Integer = 4
	
	' /////////////////////////////////////////////////////////////////////
	' // "Color" Property Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const ECHK_CL_MONO As Integer = 1
	Public Const ECHK_CL_GRAYSCALE As Integer = 2
	Public Const ECHK_CL_16 As Integer = 3
	Public Const ECHK_CL_256 As Integer = 4
	Public Const ECHK_CL_FULL As Integer = 5
	
	' /////////////////////////////////////////////////////////////////////
	' // ClearImage Method "By" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const ECHK_CLR_ALL As Integer = 1
	Public Const ECHK_CLR_BY_FILEID As Integer = 2
	Public Const ECHK_CLR_BY_FILEINDEX As Integer = 3
	Public Const ECHK_CLR_BY_IMAGETAGDATA As Integer = 4
	
	' /////////////////////////////////////////////////////////////////////
	' // RetrieveMemory Method "By" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const ECHK_LOCATE_BY_FILEID As Integer = 1
	Public Const ECHK_LOCATE_BY_FILEINDEX As Integer = 2
	Public Const ECHK_LOCATE_BY_IMAGETAGDATA As Integer = 3
	
	' /////////////////////////////////////////////////////////////////////
	' // "CropAreaID" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	Public Const ECHK_CROP_AREA_RESET_ALL As Integer = -2
	Public Const ECHK_CROP_AREA_ENTIRE_IMAGE As Integer = -1
	Public Const ECHK_CROP_AREA_RIGHT As Integer = -1
	Public Const ECHK_CROP_AREA_BOTTOM As Integer = -1
	
	' /////////////////////////////////////////////////////////////////////
	' // StatusUpdateEvent
	Public Const ECHK_SUE_SCANCOMPLETE As Integer = 11
	
	' /////////////////////////////////////////////////////////////////////
	' // DirectIO Command
	' //const LONG ECHK_DI_OUTPUT				= 1;
	Public Const ECHK_DI_ENDINSERTION_EXTEND As Integer = CHK_DI_ENDINSERTION_EXTEND
	Public Const ECHK_DI_PRESCAN As Integer = CHK_DI_PRESCAN
	Public Const ECHK_DI_READ_AREA As Integer = CHK_DI_READ_AREA
	Public Const ECHK_DI_IMAGE_FILTER As Integer = CHK_DI_IMAGE_FILTER
	Public Const ECHK_DI_ATTACHED_DATA As Integer = CHK_DI_ATTACHED_DATA
	Public Const ECHK_DI_SIZE_OFFSET As Integer = CHK_DI_SIZE_OFFSET
	Public Const ECHK_DI_BORDER_COLOR As Integer = CHK_DI_BORDER_COLOR
	Public Const ECHK_DI_ROTATE_IMAGE As Integer = CHK_DI_ROTATE_IMAGE
	Public Const ECHK_DI_TMSTORE_SET_INDEX As Integer = CHK_DI_TMSTORE_SET_INDEX
	Public Const ECHK_DI_TMSTORE_ERRORMODE As Integer = CHK_DI_TMSTORE_ERRORMODE
	Public Const ECHK_DI_TMSTORE_GET_FREEMEM As Integer = CHK_DI_TMSTORE_GET_FREEMEM
	
	' // param2 ECHK_DI_ENDINSERTION_EXTEND
	Public Const ECHK_DI_EXTEND_DEFAULT As Integer = CHK_DI_EXTEND_DEFAULT
	Public Const ECHK_DI_EXTEND_PRESCAN As Integer = CHK_DI_EXTEND_PRESCAN
	Public Const ECHK_DI_EXTEND_READAREA As Integer = CHK_DI_EXTEND_READAREA
	Public Const ECHK_DI_EXTEND_FILTER As Integer = CHK_DI_EXTEND_FILTER
	Public Const ECHK_DI_EXTEND_ATTACHED As Integer = CHK_DI_EXTEND_ATTACHED
	Public Const ECHK_DI_EXTEND_TMSTORE As Integer = CHK_DI_EXTEND_TMSTORE
	
	' // param2 ECHK_DI_ROTATE_IMAGE
	Public Const ECHK_DI_ROTATE_OFF As Integer = CHK_DI_ROTATE_OFF
	Public Const ECHK_DI_ROTATE_ON As Integer = CHK_DI_ROTATE_ON
	
	' // param2 CHK_DI_TMSTORE_ERRORMODE
	Public Const ECHK_DI_ERRORMODE_CANCEL As Integer = CHK_DI_ERRORMODE_CANCEL
	Public Const ECHK_DI_ERRORMODE_RETRY As Integer = CHK_DI_ERRORMODE_RETRY
	
	' /////////////////////////////////////////////////////////////////////
	' // ResultCodeExtennded
	Public Const OPOS_EECHK_NOCHECK As Integer = 201
	Public Const OPOS_EECHK_CHECK As Integer = 202
	Public Const OPOS_EECHK_DATAERROR As Integer = OPOS_ECHK_DATAERROR
	Public Const OPOS_EECHK_CANCEL As Integer = OPOS_ECHK_CANCEL
	Public Const OPOS_EECHK_DATAEND As Integer = OPOS_ECHK_DATAEND
	Public Const OPOS_EECHK_TIMEOUT As Integer = OPOS_ECHK_TIMEOUT
	Public Const OPOS_EECHK_NODATA As Integer = OPOS_ECHK_NODATA
	Public Const OPOS_EECHK_RESPONSE As Integer = OPOS_ECHK_RESPONSE
	Public Const OPOS_EECHK_PTRERROR As Integer = OPOS_ECHK_PTRERROR
	Public Const OPOS_EECHK_BADSIZE As Integer = OPOS_ECHK_BADSIZE
	Public Const OPOS_EECHK_ENCODE As Integer = OPOS_ECHK_ENCODE
	Public Const OPOS_EECHK_NOROOM As Integer = 203
	Public Const OPOS_EECHK_EXIST As Integer = OPOS_ECHK_EXIST
	Public Const OPOS_EECHK_SAMEID As Integer = OPOS_ECHK_SAMEID
	Public Const OPOS_EECHK_SAMETAG As Integer = OPOS_ECHK_SAMETAG
	Public Const OPOS_EECHK_TMSTORE_NOROOM As Integer = OPOS_ECHK_TMSTORE_NOROOM
	Public Const OPOS_EECHK_TMSTORE_WRITE As Integer = OPOS_ECHK_TMSTORE_WRITE
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // EPSNDISP.H
	' //
	' //   Line Display header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 95-11-29 OPOS Release 1.0                                     Kata
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property Constants for Line Display
	' /////////////////////////////////////////////////////////////////////
	Public Const OPOS_EDISP_TOOMANYWINDOWS As Integer = 1 + DISPERREXT ' // 
	Public Const OPOS_EDISP_TOOMANYDEFGLYPH As Integer = 2 + DISPERREXT ' // 
	
	' /////////////////////////////////////////////////////////////////////
	' // DirectIO Method Constants
	' /////////////////////////////////////////////////////////////////////
	' // DirectIO Command
	Public Const DISP_DI_SYNC As Integer = 0
	Public Const DISP_DI_OUTPUT_NORMAL As Integer = 1
	Public Const DISP_DI_GRAPHIC As Integer = 2
	Public Const DISP_DI_SETIMAGE As Integer = 3
	Public Const DISP_DI_GETMODE As Integer = 4
	Public Const DISP_DI_SETFONT As Integer = 5
	Public Const DISP_DI_GW_STYLE As Integer = 6
	Public Const DISP_DI_OUTPUT As Integer = DISP_DI_OUTPUT_NORMAL
	Public Const DISP_DI_FLASH_BITMAP As Integer = 7
	
	' // pData
	Public Const DISP_DI_DUMMY As Integer = 0
	Public Const DISP_DI_MODE_CHARACTER As Integer = 1
	Public Const DISP_DI_MODE_GRAPHICS As Integer = 2
	Public Const DISP_DI_FONT_A As Integer = 10
	Public Const DISP_DI_FONT_B As Integer = 11
	Public Const DISP_DI_GW_NORMAL As Integer = 20
	Public Const DISP_DI_GW_TRANSPARENT As Integer = 21
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // EPSNEJ.H
	' //
	' //    header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // new
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // DirectIO Command
	Public Const EJ_DI_RECOVER_ERROR As Integer = 0
	
	' /////////////////////////////////////////////////////////////////////
	' // ResultCodeExtennded
	Public Const OPOS_EEJ_EJ_PRINTING As Integer = EJERREXT + 1
	Public Const OPOS_EEJ_PTR_PRINTING As Integer = EJERREXT + 2
	Public Const OPOS_EEJ_MEDIUM_USED As Integer = EJERREXT + 3
	Public Const OPOS_EEJ_MARKERORDER As Integer = EJERREXT + 4
	Public Const OPOS_EEJ_BADFILE As Integer = EJERREXT + 5
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // EPSNLOCK.H
	' //
	' //   LOCK header file for EPSON Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property Constants for Scanner
	' /////////////////////////////////////////////////////////////////////
	Public Const OPOS_ELOCK_NOTSUPPORTDEVICE As Integer = 1 + LOCKERREXT ' // Device is not supported
	Public Const OPOS_ELOCK_KBHOOKOPEN As Integer = 2 + LOCKERREXT ' // KeyBoardHookDriver Open Error
	Public Const OPOS_ELOCK_KBHOOKSTART As Integer = 3 + LOCKERREXT ' // KeyBoardHookDriver Start Error
	Public Const OPOS_ELOCK_KBHOOKSTOP As Integer = 4 + LOCKERREXT ' // KeyBoardHookDriver Stop Error
	Public Const OPOS_ELOCK_KBHOOKCLOSE As Integer = 5 + LOCKERREXT ' // KeyBoardHookDriver Close Error
	Public Const OPOS_ELOCK_FAILURE As Integer = 6 + LOCKERREXT ' // 
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // EPSNMICR.H
	' //
	' //    header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' // 96-05-14 OPOS Release 1.0                                     RYU
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // DirectIO Command
	Public Const MICR_DI_CLEANING As Integer = 0
	Public Const MICR_DI_GETSTATUS As Integer = 1
	Public Const MICR_DI_RECOVER_ERROR As Integer = 5
	Public Const MICR_DI_SELECT_CHECK_FONT As Integer = 6
	
	' /////////////////////////////////////////////////
	' // pData
	
	' // Dummy
	Public Const MICR_DI_DUMMY As Integer = 0
	' // Select Check Font
	Public Const MICR_DI_MICR_CHECK_E13B As Integer = 1
	Public Const MICR_DI_MICR_CHECK_CMC7 As Integer = 2
	
	' /////////////////////////////////////////////////////////////////////
	' // ResultCodeExtennded
	Public Const OPOS_EMICR_ERRORDEVICESTATUS As Integer = MICRERREXT + 1 ' // Not used
	Public Const OPOS_EMICR_DATAERROR As Integer = MICRERREXT + 2
	Public Const OPOS_EMICR_COMPORT As Integer = MICRERREXT + 3
	Public Const OPOS_EMICR_DATAEND As Integer = MICRERREXT + 4
	Public Const OPOS_EMICR_DIGITERROR As Integer = MICRERREXT + 7
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // EPSNMSR.H
	' //
	' //   MSR header file for EPSON Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property Constants for Scanner
	' /////////////////////////////////////////////////////////////////////
	Public Const OPOS_EMSR_NOTSUPPORTDEVICE As Integer = 1 + MSRERREXT ' // Device is not supported
	Public Const OPOS_EMSR_KBHOOKOPEN As Integer = 2 + MSRERREXT ' // KeyBoardHookDriver Open Error
	Public Const OPOS_EMSR_KBHOOKSTART As Integer = 3 + MSRERREXT ' // KeyBoardHookDriver Start Error
	Public Const OPOS_EMSR_KBHOOKSTOP As Integer = 4 + MSRERREXT ' // KeyBoardHookDriver Stop Error
	Public Const OPOS_EMSR_KBHOOKCLOSE As Integer = 5 + MSRERREXT ' // KeyBoardHookDriver Close Error
	Public Const OPOS_EMSR_FAILURE As Integer = 6 + MSRERREXT ' // 
	
	' /////////////////////////////////////////////////////////////////////
	' // "ErrorEvent" Event: "ResultCodeExtended" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	Public Const OPOS_EMSR_SEPARATOR As Integer = 10 + MSRERREXT ' // 
	Public Const OPOS_EMSR_ACCOUNTNUMBER As Integer = 11 + MSRERREXT ' // 
	Public Const OPOS_EMSR_TITLE As Integer = 12 + MSRERREXT ' // 
	Public Const OPOS_EMSR_SECONDFIELD As Integer = 13 + MSRERREXT ' // 
	Public Const OPOS_EMSR_EXPIRATIONDATA As Integer = 14 + MSRERREXT ' // 
	Public Const OPOS_EMSR_SERVICECODE As Integer = 15 + MSRERREXT ' // 
	Public Const OPOS_EMSR_EXPIRATIONDATE As Integer = OPOS_EMSR_EXPIRATIONDATA
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // EPSNPTR.H
	' //
	' //   POS Printer header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // DirectIO Method Constants
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////
	' // Command
	
	' // Output Data Command
	Public Const PTR_DI_OUTPUT_NORMAL As Integer = 100
	Public Const PTR_DI_OUTPUT_REALTIME As Integer = 101
	' // Bitmap Command
	Public Const PTR_DI_SET_BITMAP_MODE As Integer = 110
	Public Const PTR_DI_PRINT_FLASH_BITMAP As Integer = 111
	Public Const PTR_DI_PRINT_FLASH_BITMAP2 As Integer = 112
	Public Const PTR_DI_DELETE_NVIMAGE As Integer = 116
	' // Select Slip or Validation 
	Public Const PTR_DI_SELECT_SLIP As Integer = 120
	Public Const PTR_DI_SLIP_CHANGE_SIDE As Integer = 121
	' // Maintenance Counter
	Public Const PTR_DI_RESET_MAINTENANCE_COUNTER As Integer = 130
	Public Const PTR_DI_GET_MAINTENANCE_COUNTER As Integer = 131
	' // International character set
	Public Const PTR_DI_SET_INTERNATIONAL_CHAR As Integer = 140
	' // Wait for output
	Public Const PTR_DI_WAIT_FOR_OUTPUT As Integer = 150
	' // Panel switch
	Public Const PTR_DI_PANEL_SWITCH As Integer = 160
	' // GetSupportFunction
	Public Const PTR_DI_GET_SUPPORT_FUNCTION As Integer = 170
	' // Select page mode
	Public Const PTR_DI_SELECT_PAGE_MODE As Integer = 180
	
	' // The Label Printer Command
	Public Const PTR_DI_LABEL_REMOVE As Integer = 200
	Public Const PTR_DI_LABEL_SET_PRINT_MODE As Integer = 201
	Public Const PTR_DI_LABEL_SET_COUNT_MODE As Integer = 202
	Public Const PTR_DI_LABEL_PRINT_COUNT As Integer = 203
	Public Const PTR_DI_LABEL_SET_COUNT_VALUE As Integer = 204
	' // Recover error
	Public Const PTR_DI_RECOVER_ERROR As Integer = 300
	' // Hardware reset
	Public Const PTR_DI_HARDWARE_RESET As Integer = 301
	' // Announciator
	Public Const PTR_DI_ANC_BUZZER As Integer = 400
	Public Const PTR_DI_ANC_LED_GREEN As Integer = 401
	Public Const PTR_DI_ANC_LED_RED As Integer = 402
	
	Public Const PTR_DI_DELAYED_CUT As Integer = 500
	Public Const PTR_DI_CUT_AND_FEED_TOF As Integer = 501
	
	Public Const PTR_DI_DRAWLINE As Integer = 650
	Public Const PTR_DI_DRAWRECTANGLE As Integer = 651
	
	Public Const PTR_DI_SET_PAPERLAYOUT As Integer = 700
	Public Const PTR_DI_GET_PAPERLAYOUT As Integer = 701
	
	Public Const PTR_DI_OPERATION_MODE As Integer = 750
	
	' // Code128
	Public Const PTR_DI_CODE128_TYPE As Integer = 800
	
	' // Slip DoubleStrike
	Public Const PTR_DI_SLIP_EMPHASIS As Integer = 900
	
	' // Ring Buzzer
	Public Const PTR_DI_RING_BUZZER As Integer = 1000 ' // for TM-P60
	Public Const PTR_DI_RING_BUZZER_WITH_TIME As Integer = 1001 ' // for UB-E02A/UB-R02A use
	' // GetBatteryStatus
	Public Const PTR_DI_GET_BATTERY_STATUS As Integer = 1100
	
	' // Select fontpage
	Public Const PTR_DI_SELECT_FONTPAGE As Integer = 1200
	
	' // Unite image and barcode image
	Public Const PTR_DI_UNITE_DATA_MODE As Integer = 1300
	
	' // SpecialFontMode
	Public Const PTR_DI_SPECIAL_FONT_MODE As Integer = 1400
	
	' // SoundMelody
	Public Const PTR_DI_SOUND_MELODY As Integer = 1500
	
	' // Set Bitmap Printing Type
	Public Const PTR_DI_SET_BITMAP_PRINTING_TYPE As Integer = 1600
	
	' // Set Slip Rotate Font Type
	Public Const PTR_DI_SET_SLIP_ROTATE_FONT_TYPE As Integer = 1700
	
	' // Print Franking
	Public Const PTR_DI_PRINT_FRANKING As Integer = 1800
	
	' // Offline Condition
	Public Const PTR_DI_GET_OFFLINE_CONDITION As Integer = 1900
	
	' // Select Slip Paper Type
	Public Const PTR_DI_SELECT_SLIP_PAPER_TYPE As Integer = 2000
	
	' /////////////////////////////////////////////////
	' // pData
	
	' // Dummy
	Public Const PTR_DI_DUMMY As Integer = 0
	' // Output Mode
	Public Const PTR_DI_ROTATE As Integer = 1
	Public Const PTR_DI_TRANSACTION As Integer = 2
	' // Bitmap Mode
	Public Const PTR_DI_BMP_NORMAL As Integer = 0
	Public Const PTR_DI_BMP_DOWNLOAD As Integer = 1
	Public Const PTR_DI_BMP_LUSTER As Integer = 2
	' // Delete NV Image
	Public Const PTR_DI_DELETE_ALL As Integer = -1
	' // Select Slip or Validation 
	Public Const PTR_DI_SLIP_FULLSLIP As Integer = 0
	Public Const PTR_DI_SLIP_VALIDATION As Integer = 1
	' // Select the printing side 
	Public Const PTR_DI_SLIP_FRONT_SIDE As Integer = 0
	Public Const PTR_DI_SLIP_REVERSE_SIDE As Integer = 1
	' // GetSupportFunction
	Public Const PTR_DI_VALIDATION As Integer = &H1
	Public Const PTR_DI_EMPHASIS As Integer = &H2
	' // SelectPageMode
	Public Const PTR_DI_NORMAL_DOT_PAGE_MODE As Integer = 0
	Public Const PTR_DI_HALF_DOT_PAGE_MODE As Integer = 1
	' // Label Print Mode
	Public Const PTR_DI_LABEL_RIGHT_SPACE As Integer = 0
	Public Const PTR_DI_LABEL_RIGHT_ZERO As Integer = 1
	Public Const PTR_DI_LABEL_LEFT_SPACE As Integer = 2
	' // International character set
	Public Const PTR_DI_CHAR_USA As Integer = 0
	Public Const PTR_DI_CHAR_FRANCE As Integer = 1
	Public Const PTR_DI_CHAR_GERMANY As Integer = 2
	Public Const PTR_DI_CHAR_UK As Integer = 3
	Public Const PTR_DI_CHAR_DENMARK1 As Integer = 4
	Public Const PTR_DI_CHAR_SWEDEN As Integer = 5
	Public Const PTR_DI_CHAR_ITALY As Integer = 6
	Public Const PTR_DI_CHAR_SPAIN1 As Integer = 7
	Public Const PTR_DI_CHAR_JAPAN As Integer = 8
	Public Const PTR_DI_CHAR_NORWAY As Integer = 9
	Public Const PTR_DI_CHAR_DENMARK2 As Integer = 10
	Public Const PTR_DI_CHAR_SPAIN2 As Integer = 11
	Public Const PTR_DI_CHAR_LATIN_AMERICA As Integer = 12
	Public Const PTR_DI_CHAR_KOREA As Integer = 13
	Public Const PTR_DI_CHAR_SLOVENIA As Integer = 14
	Public Const PTR_DI_CHAR_CROATIA As Integer = 14
	Public Const PTR_DI_CHAR_CHINA As Integer = 15
	Public Const PTR_DI_CHAR_VIETNAM As Integer = 16
	Public Const PTR_DI_CHAR_ARABIA As Integer = 17
	' // Code128 default code
	Public Const PTR_DI_CODE_A As Integer = 0
	Public Const PTR_DI_CODE_B As Integer = 1
	Public Const PTR_DI_CODE_C As Integer = 2
	' // SlipEmphasis
	Public Const PTR_DI_DISABLE_EMPHASIS As Integer = 0
	Public Const PTR_DI_ENABLE_EMPHASIS As Integer = 1
	' // GetBatteryStatus
	Public Const PTR_DI_POWERED_BY_AC As Integer = &H100
	Public Const PTR_DI_POWERED_BY_BATTERY As Integer = &H200
	Public Const PTR_DI_BATTERY_NEAR_MIDDLE As Integer = &H80
	Public Const PTR_DI_BATTERY_NEAR_LOW As Integer = &H40
	Public Const PTR_DI_BATTERY_LOW As Integer = &H20
	Public Const PTR_DI_BATTERY_FULL As Integer = &H10
	Public Const PTR_DI_BATTERY_MIDDLE As Integer = &H8
	Public Const PTR_DI_BATTERY_NEAR_EMPTY As Integer = &H4
	Public Const PTR_DI_BATTERY_CLOSE_EMPTY As Integer = &H2
	Public Const PTR_DI_BATTERY_REMOVED As Integer = &H1
	' // Select fontpage
	Public Const PTR_DI_THAICODE42 As Integer = 20
	Public Const PTR_DI_THAICODE11 As Integer = 21
	Public Const PTR_DI_THAICODE13 As Integer = 22
	Public Const PTR_DI_THAICODE14 As Integer = 23
	Public Const PTR_DI_THAICODE16 As Integer = 24
	Public Const PTR_DI_THAICODE17 As Integer = 25
	Public Const PTR_DI_THAICODE18 As Integer = 26
	Public Const PTR_DI_TCVN3_PAGE1 As Integer = 30
	Public Const PTR_DI_TCVN3_PAGE2 As Integer = 31
	' // Line Thickness
	Public Const PTR_DI_LINE_THIN As Integer = 1
	Public Const PTR_DI_LINE_NORMAL As Integer = 2
	Public Const PTR_DI_LINE_THICK As Integer = 3
	' // Operation Mode
	Public Const PTR_DI_SERIAL_MODE As Integer = 0
	Public Const PTR_DI_PEEL_OFF_MODE As Integer = 1
	
	' // Unite data mode
	Public Const PTR_DI_UNITE_EXIT As Integer = &H0
	
	Public Const PTR_DI_UNITE_TRANSPARENT As Integer = &H1
	Public Const PTR_DI_UNITE_OPAQUE As Integer = &H2
	
	Public Const PTR_DI_UNITE_UPPER_ALIGNMENT As Integer = &H100
	Public Const PTR_DI_UNITE_MIDDLE_ALIGNMENT As Integer = &H200
	Public Const PTR_DI_UNITE_LOWER_ALIGNMENT As Integer = &H400
	
	' // SpecialFontMode
	Public Const PTR_DI_FONT_NORMAL As Integer = 0
	Public Const PTR_DI_FONT_SPECIAL As Integer = 1
	
	' // Bitmap Printing Type
	Public Const PTR_DI_BITMAP_PRINTING_NORMAL As Integer = 0
	Public Const PTR_DI_BITMAP_PRINTING_MULTI_TONE As Integer = 1
	
	' // Sound Melody Pattern
	Public Const PTR_DI_SOUND_PATTERN_1 As Integer = 1
	Public Const PTR_DI_SOUND_PATTERN_2 As Integer = 2
	Public Const PTR_DI_SOUND_PATTERN_3 As Integer = 3
	Public Const PTR_DI_SOUND_PATTERN_4 As Integer = 4
	Public Const PTR_DI_SOUND_PATTERN_5 As Integer = 5
	Public Const PTR_DI_SOUND_PATTERN_ERROR As Integer = 100
	Public Const PTR_DI_SOUND_PATTERN_NOPAPER As Integer = 101
	
	' // Slip Rotate Font Type
	Public Const PTR_DI_ROTATE_FONT_A As Integer = 0
	Public Const PTR_DI_ROTATE_FONT_B As Integer = 1
	
	' // Offline Condition
	Public Const PTR_DI_CONDITION_ONLINE As Integer = 0
	Public Const PTR_DI_CONDITION_RECEIPT_ONLY_OFFLINE As Integer = 1
	Public Const PTR_DI_CONDITION_SLIP_ONLY_OFFLINE As Integer = 2
	Public Const PTR_DI_CONDITION_OFFLINE_EXECUTE As Integer = 3
	Public Const PTR_DI_CONDITION_RECOVERBLE As Integer = 4
	Public Const PTR_DI_CONDITION_UNRECOVERBLE As Integer = 5
	
	' // Select Slip Paper Type
	Public Const PTR_DI_SLIP_PAPER_NORMAL As Integer = 1
	Public Const PTR_DI_SLIP_PAPER_COPY As Integer = 2
	
	' /////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property Constants for Printer
	' /////////////////////////////////////////////////////////////////////
	Public Const OPOS_EPTR_BADSTATION As Integer = 1 + PTRERREXT ' // invalid station
	Public Const OPOS_EPTR_NOSTATION As Integer = 2 + PTRERREXT ' // station not present
	
	Public Const OPOS_EPTR_UNRECOVERABLE As Integer = 3 + PTRERREXT
	Public Const OPOS_EPTR_CUTTER As Integer = 4 + PTRERREXT
	Public Const OPOS_EPTR_MECHANICAL As Integer = 5 + PTRERREXT
	Public Const OPOS_EPTR_OVERHEAT As Integer = 6 + PTRERREXT ' // This constant is provided only for compatibility.
	Public Const OPOS_EPTR_AUTORECOVERABLE As Integer = 6 + PTRERREXT
	Public Const OPOS_EPTR_ROTATE90 As Integer = 7 + PTRERREXT
	Public Const OPOS_EPTR_LABEL_REMOVAL As Integer = 8 + PTRERREXT
	Public Const OPOS_EPTR_BUTTON_OPERATION As Integer = 9 + PTRERREXT
	Public Const OPOS_EPTR_LABEL_JAM As Integer = 10 + PTRERREXT
	Public Const OPOS_EPTR_REMOVE_BUTTON As Integer = 11 + PTRERREXT
	
	' /////////////////////////////////////////////////////////////////////
	' // "StatusUpdateEvent" Event: "Data" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	
	' // Following constants are provided only for compatibility.
	Public Const PTR_SUE_BLACK_INK_EMPTY As Integer = 7 + 2000
	Public Const PTR_SUE_BLACK_INK_NEAREMPTY As Integer = 8 + 2000
	Public Const PTR_SUE_BLACK_INK_OK As Integer = 9 + 2000
	Public Const PTR_SUE_BLACK_INK_CARTRIDGE_REMOVED As Integer = 10 + 2000
	Public Const PTR_SUE_BLACK_INK_CARTRIDGE_OK As Integer = 11 + 2000
	Public Const PTR_SUE_BLACK_HEAD_BEGIN_CLEANING As Integer = 12 + 2000
	Public Const PTR_SUE_BLACK_HEAD_END_CLEANING As Integer = 13 + 2000
	
	' // Battery status
	Public Const PTR_SUE_POWERED_BY_AC As Integer = 1 + 100000
	Public Const PTR_SUE_POWERED_BY_BATTERY As Integer = 2 + 100000
	Public Const PTR_SUE_BATTERY_FULL As Integer = 3 + 100000
	Public Const PTR_SUE_BATTERY_MIDDLE As Integer = 4 + 100000
	Public Const PTR_SUE_BATTERY_NEAR_EMPTY As Integer = 5 + 100000
	Public Const PTR_SUE_BATTERY_CLOSE_EMPTY As Integer = 6 + 100000
	Public Const PTR_SUE_BATTERY_OK As Integer = 7 + 100000
	Public Const PTR_SUE_BATTERY_REMOVED As Integer = 8 + 100000
	Public Const PTR_SUE_BATTERY_NEAR_MIDDLE As Integer = 9 + 100000
	Public Const PTR_SUE_BATTERY_NEAR_LOW As Integer = 10 + 100000
	Public Const PTR_SUE_BATTERY_LOW As Integer = 11 + 100000
	
	' /////////////////////////////////////////////////////////////////////
	' // "DirectIOEvent" Event: "Data" Parameter Constants
	' /////////////////////////////////////////////////////////////////////
	Public Const PTR_DIE_SET_BITMAP_MODE As Integer = 110
	Public Const PTR_DIE_LABEL_REMOVAL As Integer = 111
	Public Const PTR_DIE_LABEL_REMOVE_OK As Integer = 112
	Public Const PTR_DIE_BUTTON_OPERATION As Integer = 113
	Public Const PTR_DIE_LABEL_JAM As Integer = 114
	Public Const PTR_DIE_BUTTON_OK As Integer = 115
	Public Const PTR_DIE_DAMAGED_THERMAL_HEAD_ELEMENT As Integer = 116
	
	' /////////////////////////////////////////////////
	' // pData
	
	' // PTR_DIE_SET_BITMAP_MODE
	Public Const PTR_DIE_MEMORY As Integer = 1
	Public Const PTR_DIE_VRAM As Integer = 2
	Public Const PTR_DIE_NVRAM As Integer = 3
	
	' // PTR_DIE_DAMAGED_THERMAL_HEAD_ELEMENT
	Public Const PTR_DIE_TERMINATE As Integer = 0
	Public Const PTR_DIE_CONTINUATION As Integer = 1
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // EPSNSCAN.H
	' //
	' //   SCANNER header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property Constants for Scanner
	' /////////////////////////////////////////////////////////////////////
	Public Const OPOS_ESCAN_PORTCOMM As Integer = 1 + SCANERREXT ' // 
	Public Const OPOS_ESCAN_DATAFORMAT As Integer = 2 + SCANERREXT ' // 
	Public Const OPOS_ESCAN_DATAEND As Integer = 3 + SCANERREXT ' // 
	Public Const OPOS_ESCAN_FAILURE As Integer = 4 + SCANERREXT ' // 
	Public Const OPOS_ESCAN_NOTRESPONSE As Integer = 5 + SCANERREXT ' // 
	Public Const OPOS_ESCAN_LOCKED As Integer = 6 + SCANERREXT ' // 
	
	' /////////////////////////////////////////////////////////////////////
	' // "DirectIO" Method Constants for Scanner
	' /////////////////////////////////////////////////////////////////////
	Public Const OPOS_SCAN_OUTPUT As Integer = 0 ' // 
	
	Public Const OPOS_SCAN_MULTI As Integer = 1 ' // 
	
	Public Const OPOS_SCAN_RESET As Integer = 10 ' // 
	Public Const OPOS_SCAN_ENABLE As Integer = 11 ' // 
	Public Const OPOS_SCAN_NOINDICATION As Integer = 12 ' // 
	Public Const OPOS_SCAN_STATUS As Integer = 13 ' // 
	Public Const OPOS_SCAN_SWITCHREAD As Integer = 14 ' //
	Public Const OPOS_SCAN_NOTONFILE As Integer = 15 ' //
	Public Const OPOS_SCAN_REDLIGHTFLASH As Integer = 16 ' //
	' //const LONG OPOS_SCAN_DISP_DATA		= 17;	//
	Public Const OPOS_SCAN_DISP_STATUS As Integer = 17 ' //
	
	' /////////////////////////////////////////////////////////////////////
	' //
	' // EPSNTOT.H
	' //
	' //   Hard Totals header file for OPOS Applications.
	' //
	' // Modification history
	' // ------------------------------------------------------------------
	' //
	' /////////////////////////////////////////////////////////////////////
	
	' /////////////////////////////////////////////////////////////////////
	' // "ResultCodeExtended" Property Constants for HTotals
	' /////////////////////////////////////////////////////////////////////
	Public Const OPOS_ETOT_NOTMAPMEMORY As Integer = 1 + TOTERREXT ' // do not map memory 
	Public Const OPOS_ETOT_INIT_DEVICE As Integer = 2 + TOTERREXT ' // do not read initial data of device
	Public Const OPOS_ETOT_READFILE As Integer = 3 + TOTERREXT ' // do not read data
	Public Const OPOS_ETOT_WRITEFILE As Integer = 4 + TOTERREXT ' // do not write data
	Public Const OPOS_ETOT_LOCKED As Integer = 5 + TOTERREXT ' // loading another method
	Public Const OPOS_ETOT_NODEFRAGMENTATION As Integer = 6 + TOTERREXT ' // do not defragmentation
	Public Const OPOS_ETOT_NOMEMORY As Integer = 7 + TOTERREXT ' // no memory
	Public Const OPOS_ETOT_DELETE As Integer = 8 + TOTERREXT ' // Deleting the file
	Public Const OPOS_ETOT_RWPORT As Integer = 9 + TOTERREXT ' // do not read/write I/O port
	
	' /////////////////////////////////////////////////////////////////////
	' // "DirectIO" Method Constants for HTotals
	' /////////////////////////////////////////////////////////////////////
	Public Const TOT_DI_BACKUP As Integer = 1 ' //Backup 
	Public Const TOT_DI_DEFRAGMENTATION As Integer = 2 ' //Defragmentation 
	
	' /////////////////////////////////////////////////////////////////////
	' // "DirectIOEvent" Event Constants for HTotals
	' /////////////////////////////////////////////////////////////////////
	Public Const TOT_DIE_FORWARD As Integer = 1 ' // 
	Public Const TOT_DIE_ROLLBACK As Integer = 2 ' // 
End Module