Option Strict Off
Option Explicit On
Friend Class Step16
	Inherits System.Windows.Forms.Form
	Private Declare Sub Sleep Lib "kernel32" (ByVal sec As Integer)
	
	Dim bPaperSettingFlag As Boolean
	
	Private Sub cmdAsync_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdAsync.Click
		Dim bExit As Boolean
		Dim ESC As New VB6.FixedLengthString(1)
		Dim BcData As String
		Dim strDate As String
		
		If OPOSPOSPrinter1.CapRecPresent = False Then
			MsgBox("This Printer doesn't have Receipt Station.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		' Initialization
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		ESC.Value = Chr(&H1Bs)
		BcData = "4902720005074"
		bExit = False
		
		With OPOSPOSPrinter1
			.AsyncMode = True
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
				.AsyncMode = False
				Cursor = System.Windows.Forms.Cursors.Default
				Exit Sub
			End If
			
			If (.CapRecMarkFeed And PTR_MF_TO_CURRENT_TOF) Then
				.MarkFeed(PTR_MF_TO_CURRENT_TOF)
			End If
			
			'Loop
			Do 
				'Whether a bitmap can be used, or not.
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4C" & "apple    $1.00" & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
				strDate = VB6.Format(Now, "mmmm dd,")
				strDate = strDate & VB6.Format(Now, "yyyy")
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & ESC.Value & "|bC" & ESC.Value & "|cA" & "Best if used by " & strDate & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
				If .CapRecBarCode = True Then
					.printBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_EAN13, 500, .RecLineWidth / 4, PTR_BC_RIGHT, PTR_BC_TEXT_BELOW)
				End If
				
				'Feed the PTR_MF_TO_NEXT_TOF position.
				If (.CapRecMarkFeed And PTR_MF_TO_TAKEUP) Then
					.MarkFeed(PTR_MF_TO_TAKEUP)
				ElseIf (.CapRecMarkFeed And PTR_MF_TO_NEXT_TOF) Then 
					.MarkFeed(PTR_MF_TO_NEXT_TOF)
				End If
				
				If .ResultCode = OPOS_SUCCESS Then Exit Do
				
				'When error occurs, display a message to ask the user whether retry or not.
				Select Case MsgBox("Fails to output to a printer" & vbCrLf & vbCrLf & "Retry?", MsgBoxStyle.AbortRetryIgnore + MsgBoxStyle.Question)
					Case MsgBoxResult.Abort ' "Cancel"has been selected
						.ClearOutput()
						bExit = True
						Exit Do
					Case MsgBoxResult.Retry ' "Retry" has been selected
						.ClearOutput()
					Case MsgBoxResult.Ignore ' "Ignore" has been selected
						Exit Do
				End Select
			Loop 
			
			If bExit = False Then 'Has it been canceled?
				.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
				If .ResultCode <> OPOS_SUCCESS Then
					MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
					.AsyncMode = False
					' Clear the buffered data since the buffer retains print data
					' when an error occurs during printing.
					.ClearOutput()
					Cursor = System.Windows.Forms.Cursors.Default
					Exit Sub
				End If
			End If
			.AsyncMode = False
		End With
		
		Cursor = System.Windows.Forms.Cursors.Default
		
	End Sub
	
	Private Sub cmdExit_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdExit.Click
		
		Me.Close()
		
	End Sub
	
	Private Sub cmdPrint_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPrint.Click
		
		Dim bExit As Boolean
		Dim lValue As Integer
		Dim ESC As New VB6.FixedLengthString(1)
		Dim BcData As String
		Dim strDate As String
		
		If OPOSPOSPrinter1.CapRecPresent = False Then
			MsgBox("This Printer doesn't have Receipt Station.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		' Initialization
		Cursor = System.Windows.Forms.Cursors.WaitCursor
		ESC.Value = Chr(&H1Bs)
		BcData = "4902720005074"
		bExit = False
		
		With OPOSPOSPrinter1
			If (.CapRecMarkFeed And PTR_MF_TO_CURRENT_TOF) Then
				.MarkFeed(PTR_MF_TO_CURRENT_TOF)
			End If
			
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
				Cursor = System.Windows.Forms.Cursors.Default
				Exit Sub
			End If
			
			'Loop
			Do 
				'Whether a bitmap can be used, or not.
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4C" & "apple    $1.00" & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
				strDate = VB6.Format(Now, "mmmm dd,")
				strDate = strDate & VB6.Format(Now, "yyyy")
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & ESC.Value & "|bC" & ESC.Value & "|cA" & "Best if used by " & strDate & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|200uF")
				If .CapRecBarCode = True Then
					.printBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_EAN13, 500, .RecLineWidth / 4, PTR_BC_RIGHT, PTR_BC_TEXT_BELOW)
				End If
				
				'Feed the PTR_MF_TO_NEXT_TOF position.
				If (.CapRecMarkFeed And PTR_MF_TO_TAKEUP) Then
					.MarkFeed(PTR_MF_TO_TAKEUP)
				ElseIf (.CapRecMarkFeed And PTR_MF_TO_NEXT_TOF) Then 
					.MarkFeed(PTR_MF_TO_NEXT_TOF)
				End If
				
				If .ResultCode = OPOS_SUCCESS Then Exit Do
				
				'When error occurs, display a message to ask the user whether retry or not.
				Select Case MsgBox("Fails to output to a printer." & vbCrLf & vbCrLf & "Retry?", MsgBoxStyle.AbortRetryIgnore + MsgBoxStyle.Question)
					Case MsgBoxResult.Abort ' "Cancel"has been selected
						.ClearOutput()
						bExit = True
						Exit Do
					Case MsgBoxResult.Retry ' "Retry"has been selected.
						.ClearOutput()
					Case MsgBoxResult.Ignore ' "Ignore" has been selected.
						Exit Do
				End Select
			Loop 
			
			If bExit = False Then 'Has it been canceled?
				' Wait until device is 'OPOS_S_IDLE'
				While .CtlState <> OPOS_S_IDLE
					
				End While
				.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
				If .ResultCode <> OPOS_SUCCESS Then
					MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
					' Clear the buffered data since the buffer retains print data
					' when an error occurs during printing.
					.ClearOutput()
					Cursor = System.Windows.Forms.Cursors.Default
					Exit Sub
				End If
			End If
		End With
		
		Cursor = System.Windows.Forms.Cursors.Default
		
	End Sub
	
	Private Sub cmdPrintLabel_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPrintLabel.Click
		Dim lPMDescriptorList(2) As Integer
		Dim lGetPMDescriptor As Integer
		Dim lCount As Integer
		Dim lVPosition As Integer
		
		Dim bBitmapPrint As Boolean
		Dim bBarCodePrint As Boolean
		
		Dim ESC As New VB6.FixedLengthString(1)
		Dim fDate As String
		Dim BcData As String
		Dim strOutputData As String
		
		Dim strPMArea As String
		Dim strMaxHArea As String
		Dim strMaxVArea As String
		Dim strSetHPositon As String
		Dim strSetVPosition As String
		
		Dim strDrawPoint As String
		Dim pData As Integer
		
		'Check Receipt Function
		If OPOSPOSPrinter1.CapRecPresent = False Then
			MsgBox("This Printer doesn't have Receipt Station.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		'Check PageMode Function
		If (OPOSPOSPrinter1.CapRecPageMode = False) Then
			MsgBox("This printer doesn't have a PageMode printing function.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		' Initialization
		ESC.Value = Chr(&H1Bs)
		fDate = VB6.Format(Now, "mmmm dd, yyyy  AM/PM h:mm")
		
		lPMDescriptorList(0) = PTR_PM_BM_ROTATE
		lPMDescriptorList(1) = PTR_PM_BC_ROTATE
		lPMDescriptorList(2) = PTR_PM_OPAQUE
		
		Dim iRectX As Short
		Dim iRectY As Short
		Dim iStartX As Short
		Dim iStartY As Short
		Dim iEndX As Short
		Dim iEndY As Short
		With OPOSPOSPrinter1
			If (.CapRecMarkFeed And PTR_MF_TO_CURRENT_TOF) Then
				.MarkFeed(PTR_MF_TO_CURRENT_TOF)
			End If
			
			.PageModeStation = PTR_S_RECEIPT
			lGetPMDescriptor = .PageModeDescriptor
			' Select of target station of PageMode
			For lCount = 2 To 0 Step -1
				If (lPMDescriptorList(lCount) <= lGetPMDescriptor) Then
					lGetPMDescriptor = lGetPMDescriptor - lPMDescriptorList(lCount)
					Select Case lCount
						Case 0
							If .CapRecBitmap = True Then
								If InStr(.RecBitmapRotationList, "R90") <> 0 Then
									bBitmapPrint = True
								End If
							End If
						Case 1
							If .CapRecBarCode = True Then
								If InStr(.RecBarCodeRotationList, "R90") <> 0 Then
									bBarCodePrint = True
								End If
							End If
					End Select
				End If
			Next 
			
			' Initialization of PageMode area
			.PageModePrintArea = "0,0,0,0"
			.PageModeHorizontalPosition = 0
			.PageModeVerticalPosition = 0
			
			.PageModePrintDirection = PTR_PD_LEFT_TO_RIGHT
			strPMArea = .PageModeArea
			' Gets the maximum size of PageMode area
			lCount = InStr(strPMArea, ",")
			strMaxHArea = Mid(strPMArea, 1, lCount - 1)
			strMaxVArea = Mid(strPMArea, lCount + 1)
			
			' Set PageModePrintArea Property
			strSetVPosition = Str(2200 * 1)
			
			strPMArea = "0,0," & strMaxHArea & "," & strSetVPosition
			.PageModePrintArea = strPMArea
			
			' PageMode
			.PageModePrint(PTR_PM_PAGE_MODE)
			
			' Setting the outer frame.
			iRectX = Int(CDbl(strMaxHArea)) - 10
			iRectY = Int(CDbl(strSetVPosition)) - 20
			
			
			' Drawing the rectangle.
			strDrawPoint = "0,0," & Str(iRectX) & "," & Str(iRectY)
			pData = PTR_DI_LINE_THICK
			.DirectIO(PTR_DI_DRAWRECTANGLE, pData, strDrawPoint)
			
			' Sets the printing contents.
			
			.PageModeHorizontalPosition = 0 + 150
			.PageModeVerticalPosition = 0 + 100
			.PrintNormal(PTR_S_RECEIPT, "Item")
			.PageModeVerticalPosition = .RecLineSpacing * 1 + 100
			.PrintNormal(PTR_S_RECEIPT, "Price")
			.PageModeVerticalPosition = .RecLineSpacing * 2 + 100
			.PrintNormal(PTR_S_RECEIPT, "Tax(5%)")
			.PageModeVerticalPosition = .RecLineSpacing * 3 + 100
			.PrintNormal(PTR_S_RECEIPT, "Total")
			
			iStartX = 1200
			iEndX = 2100
			.PageModeHorizontalPosition = iStartX + 100
			
			.PageModeVerticalPosition = 0 + 100
			.PrintNormal(PTR_S_RECEIPT, "Apple")
			
			iStartY = .RecLineSpacing * 1
			.PageModeVerticalPosition = iStartY + 100
			.PrintNormal(PTR_S_RECEIPT, "$1.00")
			strDrawPoint = "0," & Str(iStartY) & "," & Str(iEndX) & "," & Str(iStartY)
			pData = 1
			.DirectIO(PTR_DI_DRAWLINE, pData, strDrawPoint)
			
			iStartY = .RecLineSpacing * 2
			.PageModeVerticalPosition = iStartY + 100
			.PrintNormal(PTR_S_RECEIPT, "$0.05")
			strDrawPoint = "0," & Str(iStartY) & "," & Str(iEndX) & "," & Str(iStartY)
			pData = PTR_DI_LINE_THIN
			.DirectIO(PTR_DI_DRAWLINE, pData, strDrawPoint)
			
			iStartY = .RecLineSpacing * 3
			.PageModeVerticalPosition = iStartY + 100
			.PrintNormal(PTR_S_RECEIPT, "$1.05")
			strDrawPoint = "0," & Str(iStartY) & "," & Str(iEndX) & "," & Str(iStartY)
			pData = PTR_DI_LINE_THIN
			.DirectIO(PTR_DI_DRAWLINE, pData, strDrawPoint)
			
			iStartY = .RecLineSpacing * 4
			.PageModeVerticalPosition = iStartY + 100
			
			' Drawing the ruled line between the shop name and the item.
			strDrawPoint = "0," & Str(iStartY) & "," & Str(iRectX) & "," & Str(iStartY)
			pData = PTR_DI_LINE_NORMAL
			.DirectIO(PTR_DI_DRAWLINE, pData, strDrawPoint)
			
			' Drawing the ruled line between the item name and the item.
			strDrawPoint = Str(iStartX) & "," & "0" & "," & Str(iStartX) & "," & Str(iStartY)
			pData = PTR_DI_LINE_NORMAL
			.DirectIO(PTR_DI_DRAWLINE, pData, strDrawPoint)
			
			iStartX = iEndX
			
			' Drawing the ruled line between the item and the barcode.
			strDrawPoint = Str(iStartX) & "," & "0" & "," & Str(iStartX) & "," & Str(iStartY)
			pData = PTR_DI_LINE_NORMAL
			.DirectIO(PTR_DI_DRAWLINE, pData, strDrawPoint)
			
			' Print Bitmap
			.PageModeVerticalPosition = .RecLineSpacing * 4 + 100
			.PageModeHorizontalPosition = 150
			If (bBitmapPrint) Then
				.PrintBitmap(PTR_S_RECEIPT, My.Application.Info.DirectoryPath & "\Logo.bmp", .RecLineWidth / 10, PTR_BM_LEFT)
			End If
			.PageModeVerticalPosition = .RecLineSpacing * 4 + 200
			.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|2C" & ESC.Value & "|cA" & "OPOS Store")
			
			' Print BarCode
			If bBarCodePrint = True Then
				'            .PageModeHorizontalPosition = iStartX + 100
				.PageModeHorizontalPosition = 2300
				.PageModeVerticalPosition = 500
				printBarCode()
			End If
			
			.PageModePrint(PTR_PM_NORMAL)
			
			If (.ResultCode = OPOS_SUCCESS) Then
				If .CapRecPapercut = True Then 'Cut function, or not.
					.CutPaper(100)
				End If
			Else
				MsgBox("Cannot use a POS Printer" & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended), MsgBoxStyle.Critical, "Label Printing")
				.PageModePrint(PTR_PM_CANCEL)
			End If
			
			'Feed the PTR_MF_TO_NEXT_TOF position.
			If (.CapRecMarkFeed And PTR_MF_TO_TAKEUP) Then
				.MarkFeed(PTR_MF_TO_TAKEUP)
			ElseIf (.CapRecMarkFeed And PTR_MF_TO_NEXT_TOF) Then 
				.MarkFeed(PTR_MF_TO_NEXT_TOF)
			End If
		End With
	End Sub
	
	Private Sub cmdReceipt_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdReceipt.Click
		Dim bExit As Boolean
		Dim rcSpacing As Integer
		Dim rcHeight As Integer
		Dim ESC As New VB6.FixedLengthString(1)
		Dim RotateType As Integer
		Dim bBitmapPrint As Boolean
		Dim bBarCodePrint As Boolean
		Dim BcData As String
		Dim strDate As String
		
		If OPOSPOSPrinter1.CapRecPresent = False Then
			MsgBox("This Printer doesn't have Receipt Station.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		'Check Rotate Function
		If OPOSPOSPrinter1.CapRecLeft90 = False Then
			MsgBox("This printer does not have a rotation printing function.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		RotateType = 0
		bBitmapPrint = False
		bBarCodePrint = False
		With OPOSPOSPrinter1
			If .CapRecBitmap = True Then
				If InStr(.RecBitmapRotationList, "L90") <> 0 Then
					RotateType = RotateType + PTR_RP_BITMAP
					bBitmapPrint = True
				End If
			End If
			If .CapRecBarCode = True Then
				If InStr(.RecBarCodeRotationList, "L90") <> 0 Then
					RotateType = RotateType + PTR_RP_BARCODE
					bBarCodePrint = True
				End If
			End If
		End With
		
		
		' Initialization
		ESC.Value = Chr(&H1Bs)
		bExit = False
		BcData = "49027200"
		
		With OPOSPOSPrinter1
			If (.CapRecMarkFeed And PTR_MF_TO_CURRENT_TOF) Then
				.MarkFeed(PTR_MF_TO_CURRENT_TOF)
			End If
			
			'Batch processing mode
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_TRANSACTION)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
				Exit Sub
			End If
			
			'Rotate 90
			.RotatePrint(PTR_S_RECEIPT, PTR_RP_LEFT90 + RotateType)
			
			'Loop
			Do 
				rcSpacing = .RecLineSpacing 'Keep the default line spacing
				rcHeight = .RecLineHeight 'Keep the default line height
				
				If .CapRecBitmap = True Then
					.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|1B")
				End If
				'Printing process
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|4C" & ESC.Value & "|bC" & "apple" & vbCrLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|2uC" & ESC.Value & "|4C" & "$1.00" & vbCrLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|600uF")
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|N" & "Best if used " & vbLf)
				.PrintNormal(PTR_S_RECEIPT, "by" & vbLf)
				strDate = VB6.Format(Now, "mmmm dd,")
				.PrintNormal(PTR_S_RECEIPT, strDate & vbLf)
				strDate = VB6.Format(Now, "yyyy")
				.PrintNormal(PTR_S_RECEIPT, strDate & vbLf)
				.PrintNormal(PTR_S_RECEIPT, ESC.Value & "|600uF")
				If .CapRecBarCode = True Then
					.printBarCode(PTR_S_RECEIPT, BcData, PTR_BCS_EAN8, 500, .RecLineWidth / 3, PTR_BC_RIGHT, PTR_BC_TEXT_BELOW)
				End If
				
				'When outputting normally,breakout of the loop.
				If .ResultCode = OPOS_SUCCESS Then Exit Do
				'When error occurs, display a message to ask the user whether retry or not.
				Select Case MsgBox("Fails to output to a printer." & vbCrLf & vbCrLf & "Retry?", MsgBoxStyle.AbortRetryIgnore + MsgBoxStyle.Question)
					Case MsgBoxResult.Abort ' "Cancel"has been selected
						'Clear all the buffer, and exit.
						.ClearOutput()
						bExit = True
						Exit Do
					Case MsgBoxResult.Retry ' "Retry"has been selected.
						'Clear all the buffer data, and retry.
						.ClearOutput()
					Case MsgBoxResult.Ignore '"Ignore" has been selected.
						Exit Do
				End Select
			Loop 
			
			.RotatePrint(PTR_S_RECEIPT, PTR_RP_NORMAL)
			
			If bExit = False Then
				If (.ResultCode = OPOS_SUCCESS) Then
					'Feed the PTR_MF_TO_NEXT_TOF position.
					If (.CapRecMarkFeed And PTR_MF_TO_TAKEUP) Then
						.MarkFeed(PTR_MF_TO_TAKEUP)
					ElseIf (.CapRecMarkFeed And PTR_MF_TO_NEXT_TOF) Then 
						.MarkFeed(PTR_MF_TO_NEXT_TOF)
					End If
				Else
					MsgBox("Cannot use a POS Printer" & vbCrLf & "ResultCode = " & CStr(.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(.ResultCodeExtended), 0, "Print Receipt")
					.ClearOutput()
				End If
			End If
			
			' Wait until device is 'OPOS_S_IDLE'
			While .CtlState <> OPOS_S_IDLE
			End While
			'Print all the buffer data, and exit the batch processing mode.
			.TransactionPrint(PTR_S_RECEIPT, PTR_TP_NORMAL)
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Cannot use a POS Printer.", MsgBoxStyle.Exclamation)
				.RecLineSpacing = rcSpacing
				.RecLineHeight = rcHeight
				' Clear the buffered data since the buffer retains print data
				' when an error occurs during printing.
				.ClearOutput()
				Exit Sub
			End If
			
			.RecLineSpacing = rcSpacing
			.RecLineHeight = rcHeight
		End With
		
	End Sub
	
	Private Sub cmdSetPaperType_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdSetPaperType.Click
		' Setting Paper Layout Infomation To Service Object
		
		Dim iPaperType As Short
		Dim strPaperSize As String
		Dim pData As Integer
		Dim strParam As String
		
		' Get Paprt Type From Radio Button
		If optReceipt.Checked = True Then
			iPaperType = 48
			strPaperSize = "0,0,0,0,0,6000"
		End If
		If optBMReceipt.Checked = True Then
			iPaperType = 51
			strPaperSize = "0,250,-250,0,0,6000"
		End If
		If optLabel.Checked = True Then
			iPaperType = 49
			strPaperSize = "0,150,250,0,-150,6000"
		End If
		If optBMLabel.Checked = True Then
			iPaperType = 50
			strPaperSize = "0,150,250,0,-150,6000"
		End If
		
		' Create Third Parameter
		strParam = Str(iPaperType) & "," & strPaperSize
		strParam = Trim(strParam)
		
		OPOSPOSPrinter1.DirectIO(PTR_DI_SET_PAPERLAYOUT, pData, strParam)
		If OPOSPOSPrinter1.ResultCode <> OPOS_SUCCESS Then
			MsgBox("Failed to get the paper's information.", MsgBoxStyle.Exclamation)
			Exit Sub
		End If
		
		bPaperSettingFlag = True
		If iPaperType = 49 Or iPaperType = 50 Then
			cmdPrint.Enabled = False
			cmdAsync.Enabled = False
			cmdReceipt.Enabled = False
			Frame1.Enabled = False
			cmdPrintLabel.Enabled = True
			Frame4.Enabled = True
		ElseIf iPaperType = 48 Or iPaperType = 51 Then 
			cmdPrint.Enabled = True
			cmdAsync.Enabled = True
			cmdReceipt.Enabled = True
			Frame1.Enabled = True
			cmdPrintLabel.Enabled = False
			Frame4.Enabled = False
		End If
	End Sub
	
	Private Sub OPOSPOSPrinter1_ErrorEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposPOSPrinter_CCO._IOPOSPOSPrinterEvents_ErrorEventEvent) Handles OPOSPOSPrinter1.ErrorEvent
		
		If (MsgBox("Printer Error." & vbCrLf & vbCrLf & "ResultCode = " & CStr(eventArgs.ResultCode) & vbCrLf & "ResultCodeExtended = " & CStr(eventArgs.ResultCodeExtended), MsgBoxStyle.OKCancel + MsgBoxStyle.Information) = MsgBoxResult.Cancel) Then
			eventArgs.pErrorResponse = OPOS_ER_CLEAR
		End If
		
	End Sub
	
	Private Sub OPOSPOSPrinter1_OutputCompleteEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposPOSPrinter_CCO._IOPOSPOSPrinterEvents_OutputCompleteEventEvent) Handles OPOSPOSPrinter1.OutputCompleteEvent
		
		'Notify that printing is completed when it is asnchronous.
		MsgBox("Complete printing", MsgBoxStyle.Information)
		
	End Sub
	
	
	Private Sub OPOSPOSPrinter1_StatusUpdateEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposPOSPrinter_CCO._IOPOSPOSPrinterEvents_StatusUpdateEventEvent) Handles OPOSPOSPrinter1.StatusUpdateEvent
		'When there is a change of the status on the printer, the event is fired.
		
		Dim bRecEnb As Boolean
		
		bRecEnb = True
		
		'Make messages for the each event information.
		Select Case eventArgs.Data
			Case PTR_SUE_COVER_OPEN 'Printer cover is open.
				bRecEnb = False
			Case PTR_SUE_REC_EMPTY 'No receipt paper.
				bRecEnb = False
		End Select
		
		
		With OPOSPOSPrinter1
			'Check receipt function and set button state.
			If .CapRecPresent = True And bRecEnb = True Then
				If bPaperSettingFlag = True Then
					If optReceipt.Checked = True Or optBMReceipt.Checked = True Then
						cmdPrint.Enabled = True
						cmdAsync.Enabled = True
						cmdReceipt.Enabled = True
						Frame1.Enabled = True
						cmdPrintLabel.Enabled = False
						Frame4.Enabled = False
					ElseIf optLabel.Checked = True Or optBMLabel.Checked = True Then 
						cmdPrint.Enabled = False
						cmdAsync.Enabled = False
						cmdReceipt.Enabled = False
						Frame1.Enabled = False
						cmdPrintLabel.Enabled = True
						Frame4.Enabled = True
					End If
				End If
				Frame2.Enabled = True
				cmdSetPaperType.Enabled = True
				optReceipt.Enabled = True
				optLabel.Enabled = True
				optBMReceipt.Enabled = True
				optBMLabel.Enabled = True
			Else
				cmdPrint.Enabled = False
				cmdAsync.Enabled = False
				cmdReceipt.Enabled = False
				Frame1.Enabled = False
				
				Frame2.Enabled = False
				cmdSetPaperType.Enabled = False
				optReceipt.Enabled = False
				optLabel.Enabled = False
				optBMReceipt.Enabled = False
				optBMLabel.Enabled = False
				
				cmdPrintLabel.Enabled = False
				Frame4.Enabled = False
			End If
			
			'Check rotate print function and set button state.
			If (.CapRecLeft90 = False) Or (.CapRecRight90 = False) Then
				cmdReceipt.Enabled = False
			End If
			
		End With
		
		'Enable to [Close] button only.
		cmdExit.Enabled = True
		
	End Sub
	
	Private Sub OPOSPOSPrinter1_DirectIOEvent(ByVal eventSender As System.Object, ByVal eventArgs As AxOposPOSPrinter_CCO._IOPOSPOSPrinterEvents_DirectIOEventEvent) Handles OPOSPOSPrinter1.DirectIOEvent
		' Create Message Each Event Type
		Select Case eventArgs.EventNumber
			Case PTR_DIE_LABEL_REMOVAL
				MsgBox("Remove the label.", MsgBoxStyle.Exclamation)
		End Select
		
	End Sub
	
	Private Sub Step16_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		Dim strParam As String
		Dim RetryCount As Integer
		
		bPaperSettingFlag = False
		Dim pData As Integer
		With OPOSPOSPrinter1
			.Open("Unit1")
			'Check whether the device is succeed to open, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to open the device.")
				GoTo LoadError
				Exit Sub
			End If
			
			.ClaimDevice(1000)
			'Check whether the device is claim to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Fails to claim the device.")
				GoTo LoadError
			End If
			
			.DeviceEnabled = True
			'Check whether the device is enable to use, or not
			If .ResultCode <> OPOS_SUCCESS Then
				MsgBox("Disable to use the device.")
				GoTo LoadError
				Exit Sub
			End If
			
			.MapMode = PTR_MM_METRIC
			.RecLetterQuality = True
			
			If .CapRecBitmap = True Then
				RetryCount = 0
				Do While RetryCount < 5
					.SetBitmap(1, PTR_S_RECEIPT, My.Application.Info.DirectoryPath & "\Logo.bmp", .RecLineWidth / 2, PTR_BM_CENTER)
					If (.ResultCode = OPOS_E_ILLEGAL) And (.ResultCodeExtended = OPOS_EX_DEVBUSY) Then
						RetryCount = RetryCount + 1
						Sleep(1000)
					Else
						Exit Do
					End If
				Loop 
				
				If .ResultCode <> OPOS_SUCCESS Then
					MsgBox("Fails to set bitmap.")
					GoTo LoadError
				End If
			End If
			
			If (.CapRecLeft90 = False) Or (.CapRecRight90 = False) Then
				cmdReceipt.Enabled = False
			End If
			
			' Sets the peel-off issuance mode.
			pData = PTR_DI_PEEL_OFF_MODE
			strParam = ""
			.DirectIO(PTR_DI_OPERATION_MODE, pData, strParam)
			
		End With
		
		MsgBox("First, specify the paper's type.", MsgBoxStyle.Exclamation)
		Exit Sub
		
		'Error disposal
LoadError: 
		Dim OBJ As Object
		'Disable all buttons
		For	Each OBJ In Me.Controls
			If OBJ.Name <> "OPOSPOSPrinter1" Then
				OBJ.Enabled = False
			End If
		Next OBJ
		'Enable to [Close] button only.
		cmdExit.Enabled = True
		
	End Sub
	
	Private Sub Step16_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		
		With OPOSPOSPrinter1
			.DeviceEnabled = False
			.ReleaseDevice()
			.Close()
		End With
		
	End Sub
	
	Private Sub optBMLabel_CheckedChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles optBMLabel.CheckedChanged
		If eventSender.Checked Then
			Dim txtSetPaperSize As Object
			txtSetPaperSize = "0,150,250,0,-150,6000"
		End If
	End Sub
	
	Private Sub optBMReceipt_CheckedChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles optBMReceipt.CheckedChanged
		If eventSender.Checked Then
			Dim txtSetPaperSize As Object
			txtSetPaperSize = "0,250,-250,0,0,6000"
		End If
	End Sub
	
	Private Sub optLabel_CheckedChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles optLabel.CheckedChanged
		If eventSender.Checked Then
			Dim txtSetPaperSize As Object
			txtSetPaperSize = "0,150,250,0,-150,6000"
		End If
	End Sub
	
	Private Sub optReceipt_CheckedChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles optReceipt.CheckedChanged
		If eventSender.Checked Then
			Dim txtSetPaperSize As Object
			txtSetPaperSize = "0,0,0,0,0,6000"
		End If
	End Sub
	
	Private Sub printBarCode()
		' Printing the barcode.
		' All the type of printable barcodes are described here.
		' If the values of the set width and height, at the time of the execution,
		' are not matched with the type and size of the paper, the following things will happen.
		' 1.The barcode will not fit in the specified area.
		' 2.The barcode will not print.
		' 3.It will print extending over several sheets of label paper.
		
		Dim iBarCodeHeight As Short
		Dim iBarCodeWidth As Short
		Dim iBarCodeAlighment As Short
		
		Dim iBarCodeIndex As Short
		Dim lBarCodeItem As Integer
		
		Dim strSeparater As String
		Dim strComposite As String
		
		Dim lComposite As Integer
		lComposite = PTR_BCS_PDF417 * (16 ^ 4)
		
		strSeparater = "\|"
		strComposite = "1A2B3C4D5E" & strSeparater
		
		With OPOSPOSPrinter1
			iBarCodeHeight = 450
			iBarCodeWidth = .RecLineWidth / 4
			iBarCodeAlighment = PTR_BC_LEFT
			
			' Select Barcode Type
			lBarCodeItem = PTR_BCS_EAN13
			
			' Print BarCode
			Select Case lBarCodeItem
				Case PTR_BCS_EAN8
					.printBarCode(PTR_S_RECEIPT, "4902720", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_EAN13
					.printBarCode(PTR_S_RECEIPT, "4902720005074", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_EAN128
					.printBarCode(PTR_S_RECEIPT, "1234", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_Code93
					.printBarCode(PTR_S_RECEIPT, "1234", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_Code39
					.printBarCode(PTR_S_RECEIPT, "1234", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_Code128
					.printBarCode(PTR_S_RECEIPT, "1234", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_Code128_Parsed
					.printBarCode(PTR_S_RECEIPT, "1234", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_UPCA
					.printBarCode(PTR_S_RECEIPT, "012345678905", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_UPCE
					.printBarCode(PTR_S_RECEIPT, "123456", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_Codabar
					.printBarCode(PTR_S_RECEIPT, "A1234A", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_ITF
					.printBarCode(PTR_S_RECEIPT, "1234", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_MAXICODE
					.printBarCode(PTR_S_RECEIPT, Chr(&H30s) & Chr(&H1Ds) & Chr(&H30s) & Chr(&H1Ds) & Chr(&H30s) & Chr(&H1Ds), lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 0
					.printBarCode(PTR_S_RECEIPT, Chr(&H30s) & Chr(&H1Ds) & Chr(&H30s) & Chr(&H1Ds) & Chr(&H30s) & Chr(&H1Ds), lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 1
					.printBarCode(PTR_S_RECEIPT, "1A2B3C4D5E", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 2
					.printBarCode(PTR_S_RECEIPT, "1A2B3C4D5E", lBarCodeItem, 1000, 1000, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_PDF417
					.printBarCode(PTR_S_RECEIPT, "1234", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 3
					.printBarCode(PTR_S_RECEIPT, "1A2B3C4D5E", lBarCodeItem, 1000, 1000, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 4
					.printBarCode(PTR_S_RECEIPT, "1A2B3C4D5E", lBarCodeItem, 1000, 1000, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
					
					'RSS14 And RSS Expanded
				Case PTR_BCS_RSS14
					.printBarCode(PTR_S_RECEIPT, "1234567890123", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 5
					.printBarCode(PTR_S_RECEIPT, "1234567890123", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 7
					.printBarCode(PTR_S_RECEIPT, "1234567890123", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 8
					.printBarCode(PTR_S_RECEIPT, "1234567890123", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_RSS_EXPANDED
					.printBarCode(PTR_S_RECEIPT, "1234", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 6
					.printBarCode(PTR_S_RECEIPT, "1234567890123", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 9
					.printBarCode(PTR_S_RECEIPT, "1234", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
					
					' Composite
				Case PTR_BCS_EAN8 + lComposite
					.printBarCode(PTR_S_RECEIPT, strComposite & "4902720", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_EAN13 + lComposite
					.printBarCode(PTR_S_RECEIPT, strComposite & "4902720005074", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_EAN128 + lComposite
					.printBarCode(PTR_S_RECEIPT, strComposite & "1234", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_UPCA + lComposite
					.printBarCode(PTR_S_RECEIPT, strComposite & "012345678905", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_UPCE + lComposite
					.printBarCode(PTR_S_RECEIPT, strComposite & "123456", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_RSS14 + lComposite
					.printBarCode(PTR_S_RECEIPT, strComposite & "1234567890123", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_RSS_EXPANDED + lComposite
					.printBarCode(PTR_S_RECEIPT, strComposite & "1234", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 5 + lComposite
					.printBarCode(PTR_S_RECEIPT, strComposite & "1234567890123", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 7 + lComposite
					.printBarCode(PTR_S_RECEIPT, strComposite & "1234567890123", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 8 + lComposite
					.printBarCode(PTR_S_RECEIPT, strComposite & "1234567890123", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 6 + lComposite
					.printBarCode(PTR_S_RECEIPT, strComposite & "1234567890123", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
				Case PTR_BCS_OTHER + 9 + lComposite
					.printBarCode(PTR_S_RECEIPT, strComposite & "1234", lBarCodeItem, iBarCodeHeight, iBarCodeWidth, iBarCodeAlighment, PTR_BC_TEXT_BELOW)
					
				Case Else
					MsgBox("Unable to print the specified barcode.", MsgBoxStyle.Exclamation)
			End Select
			
			If (.ResultCode <> OPOS.OPOS_SUCCESS) Then
				MsgBox("Failed BarCode Printing.", MsgBoxStyle.Exclamation)
			End If
		End With
		
	End Sub
End Class